/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterator;

public class CachingIterable<T>
implements CloseableIterable<T> {
    public static final int DEFAULT_MAX_SIZE = 100000;
    private final Iterable<T> iterable;
    private final int maxSize;
    private boolean tooLarge;
    private Iterable<T> cachedIterable;

    public CachingIterable(Iterable<T> iterable) {
        this(iterable, 100000);
    }

    public CachingIterable(Iterable<T> iterable, int maxSize) {
        if (null == iterable) {
            this.iterable = Collections.emptyList();
            this.cachedIterable = Collections.emptyList();
        } else if (iterable instanceof Collection) {
            this.iterable = iterable;
            this.cachedIterable = iterable;
        } else {
            this.iterable = iterable;
        }
        this.maxSize = maxSize;
        this.tooLarge = false;
    }

    @Override
    public CloseableIterator<T> iterator() {
        if (null != this.cachedIterable) {
            return new WrappedCloseableIterator<T>(this.cachedIterable.iterator());
        }
        if (this.tooLarge) {
            return new WrappedCloseableIterator<T>(this.iterable.iterator());
        }
        return new CachingIterator();
    }

    @Override
    public void close() {
        CloseableUtil.close(this.iterable);
    }

    private class CachingIterator
    implements CloseableIterator<T> {
        private final Iterator<T> iterator;
        private List<T> cache;
        private boolean closed;

        private CachingIterator() {
            this.iterator = CachingIterable.this.iterable.iterator();
            this.cache = new ArrayList(Math.min(100000, CachingIterable.this.maxSize));
            this.closed = false;
        }

        @Override
        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            if (this.iterator.hasNext()) {
                return true;
            }
            CachingIterable.this.cachedIterable = this.cache;
            this.close();
            return false;
        }

        @Override
        public T next() {
            if (this.closed) {
                throw new NoSuchElementException("Iterator has been closed");
            }
            Object next = this.iterator.next();
            if (null != this.cache) {
                if (this.cache.size() < CachingIterable.this.maxSize) {
                    this.cache.add(next);
                } else {
                    CachingIterable.this.tooLarge = true;
                    this.cache = null;
                }
            }
            return next;
        }

        @Override
        public void close() {
            this.closed = true;
            CloseableUtil.close(this.iterator);
            CachingIterable.this.close();
        }
    }
}

