/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Iterator;
import java.util.stream.Stream;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.EmptyCloseableIterator;

public class StreamIterator<T>
implements CloseableIterator<T> {
    private final Stream<T> stream;
    private final Iterator<T> iterator;

    public StreamIterator() {
        this(null);
    }

    public StreamIterator(Stream<T> stream) {
        if (null == stream) {
            this.stream = Stream.empty();
            this.iterator = new EmptyCloseableIterator();
        } else {
            this.stream = stream;
            this.iterator = stream.iterator();
        }
    }

    @Override
    public void close() {
        CloseableUtil.close(this.iterator);
        CloseableUtil.close(this.stream);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public Stream<T> getStream() {
        return this.stream;
    }
}

