/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.Properties;
import uk.gov.gchq.gaffer.data.element.comparison.ComparableOrToStringComparator;
import uk.gov.gchq.gaffer.data.element.id.DirectedType;
import uk.gov.gchq.gaffer.data.element.id.EdgeId;

@JsonPropertyOrder(value={"class", "group", "source", "destination", "directed", "matchedVertex", "properties"}, alphabetic=true)
public class Edge
extends Element
implements EdgeId {
    private static final Logger LOGGER = LoggerFactory.getLogger(Edge.class);
    private static final long serialVersionUID = -5596452468277807842L;
    private static final Comparator<Object> VERTEX_COMPARATOR = new ComparableOrToStringComparator();
    private Object source;
    private Object destination;
    private boolean directed;
    private EdgeId.MatchedVertex matchedVertex;

    Edge() {
    }

    public Edge(String group) {
        super(group);
    }

    public Edge(String group, Object source, Object destination, boolean directed) {
        this(group, source, destination, directed, null, null);
    }

    public Edge(String group, Object source, Object destination, boolean directed, EdgeId.MatchedVertex matchedVertex, Properties properties) {
        super(group, properties);
        this.source = source;
        this.destination = destination;
        this.directed = directed;
        this.matchedVertex = matchedVertex;
        this.orderVertices();
    }

    @JsonCreator
    Edge(@JsonProperty(value="group") String group, @JsonProperty(value="source") Object source, @JsonProperty(value="destination") Object destination, @JsonProperty(value="directed") Boolean directed, @JsonProperty(value="directedType") DirectedType directedType, @JsonProperty(value="matchedVertex") EdgeId.MatchedVertex matchedVertex, @JsonProperty(value="properties") Properties properties) {
        this(group, source, destination, Edge.getDirected(directed, directedType), matchedVertex, properties);
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Object getDestination() {
        return this.destination;
    }

    @Override
    @JsonIgnore
    public DirectedType getDirectedType() {
        if (this.isDirected()) {
            return DirectedType.DIRECTED;
        }
        return DirectedType.UNDIRECTED;
    }

    @Override
    @JsonIgnore(value=false)
    @JsonGetter(value="directed")
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public EdgeId.MatchedVertex getMatchedVertex() {
        return this.matchedVertex;
    }

    @Override
    public Object getIdentifier(IdentifierType identifierType) {
        switch (identifierType) {
            case GROUP: {
                return this.getGroup();
            }
            case SOURCE: {
                return this.getSource();
            }
            case DESTINATION: {
                return this.getDestination();
            }
            case DIRECTED: {
                return this.isDirected();
            }
            case MATCHED_VERTEX: {
                return this.getMatchedVertexValue();
            }
            case ADJACENT_MATCHED_VERTEX: {
                return this.getAdjacentMatchedVertexValue();
            }
        }
        return null;
    }

    @Override
    void putIdentifier(IdentifierType identifierType, Object value) {
        switch (identifierType) {
            case GROUP: {
                this.setGroup((String)value);
                break;
            }
            case SOURCE: 
            case MATCHED_VERTEX: {
                this.source = value;
                break;
            }
            case DESTINATION: 
            case ADJACENT_MATCHED_VERTEX: {
                this.destination = value;
                break;
            }
            case DIRECTED: {
                this.directed = null != value && value instanceof Boolean && (Boolean)value != false || value instanceof DirectedType && ((DirectedType)((Object)value)).isDirected();
                break;
            }
            default: {
                LOGGER.error("Unknown identifier type: {} detected.", (Object)identifierType);
            }
        }
    }

    @Override
    public void setIdentifiers(Object source, Object destination, DirectedType directedType) {
        this.setIdentifiers(source, destination, directedType.isDirected());
    }

    public void setIdentifiers(Object source, Object destination, boolean directed) {
        this.setIdentifiers(source, destination, directed, this.matchedVertex);
    }

    @Override
    public void setIdentifiers(Object source, Object destination, DirectedType directedType, EdgeId.MatchedVertex matchedVertex) {
        this.setIdentifiers(source, destination, directedType.isDirected(), matchedVertex);
    }

    public void setIdentifiers(Object source, Object destination, boolean directed, EdgeId.MatchedVertex matchedVertex) {
        this.source = source;
        this.destination = destination;
        this.directed = directed;
        this.matchedVertex = matchedVertex;
        this.orderVertices();
    }

    private void orderVertices() {
        if (!this.directed && VERTEX_COMPARATOR.compare(this.source, this.destination) > 0) {
            this.swapVertices();
        }
    }

    private void swapVertices() {
        Object tmp = this.source;
        this.source = this.destination;
        this.destination = tmp;
        if (this.matchedVertex != null) {
            this.matchedVertex = this.matchedVertex == EdgeId.MatchedVertex.DESTINATION ? EdgeId.MatchedVertex.SOURCE : EdgeId.MatchedVertex.DESTINATION;
        }
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(21, 3).appendSuper(super.hashCode()).append(this.getSource()).append(this.getDestination()).append(this.isDirected()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return null != obj && obj instanceof Edge && this.equals((Edge)obj);
    }

    public boolean equals(Edge edge) {
        return null != edge && new EqualsBuilder().append(this.isDirected(), edge.isDirected()).append(this.getSource(), edge.getSource()).append(this.getDestination(), edge.getDestination()).appendSuper(super.equals(edge)).isEquals();
    }

    @Override
    public Edge emptyClone() {
        return new Edge(this.getGroup(), this.getSource(), this.getDestination(), this.isDirected(), this.getMatchedVertex(), new Properties());
    }

    @Override
    public Edge shallowClone() {
        return (Edge)super.shallowClone();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("source", this.getSource()).append("destination", this.getDestination()).append("directed", this.isDirected()).append("matchedVertex", (Object)this.getMatchedVertex()).appendSuper(super.toString()).build();
    }

    private static boolean getDirected(Boolean directed, DirectedType directedType) {
        if (null != directed) {
            if (null != directedType) {
                throw new IllegalArgumentException("Use either 'directed' or 'directedType' - not both.");
            }
            return directed;
        }
        return DirectedType.isDirected(directedType);
    }

    public static class Builder {
        private String group = "UNKNOWN";
        private Object source;
        private Object dest;
        private boolean directed;
        private EdgeId.MatchedVertex matchedVertex;
        private Properties properties = new Properties();

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder source(Object source) {
            this.source = source;
            return this;
        }

        public Builder dest(Object dest) {
            this.dest = dest;
            return this;
        }

        public Builder directed(boolean directed) {
            this.directed = directed;
            return this;
        }

        public Builder matchedVertex(EdgeId.MatchedVertex matchedVertex) {
            this.matchedVertex = matchedVertex;
            return this;
        }

        public Builder property(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        public Edge build() {
            return new Edge(this.group, this.source, this.dest, this.directed, this.matchedVertex, this.properties);
        }
    }
}

