/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.Properties;
import uk.gov.gchq.gaffer.data.element.id.ElementId;

public abstract class Element
implements ElementId {
    public static final String DEFAULT_GROUP = "UNKNOWN";
    private Properties properties;
    private String group;

    Element() {
        this(DEFAULT_GROUP);
    }

    Element(String group) {
        this(group, new Properties());
    }

    Element(String group, Properties properties) {
        this.group = group;
        this.properties = null == properties ? new Properties() : properties;
    }

    public void putProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void copyProperties(Properties properties) {
        if (null != properties) {
            for (Map.Entry entry : properties.entrySet()) {
                this.putProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT, property="class")
    public Properties getProperties() {
        return this.properties;
    }

    public Object removeProperty(String propName) {
        return this.properties.remove(propName);
    }

    public String getGroup() {
        return this.group;
    }

    public int hashCode() {
        return new HashCodeBuilder(53, 17).append((Object)this.group).append((Object)this.properties).toHashCode();
    }

    public boolean shallowEquals(Object obj) {
        return null != obj && obj instanceof Element && this.shallowEquals((Element)obj);
    }

    public boolean shallowEquals(Element element) {
        return null != element && new EqualsBuilder().append((Object)this.group, (Object)element.getGroup()).isEquals();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        Element element = (Element)obj;
        return new EqualsBuilder().append((Object)this.group, (Object)element.group).append((Object)this.properties, (Object)element.properties).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("group", (Object)this.group).append("properties", (Object)this.properties).build();
    }

    @JsonIgnore
    public abstract Element emptyClone();

    public Element shallowClone() {
        Element element = this.emptyClone();
        element.setProperties(this.getProperties().clone());
        return element;
    }

    @JsonIgnore
    public abstract Object getIdentifier(IdentifierType var1);

    abstract void putIdentifier(IdentifierType var1, Object var2);

    @JsonIgnore
    public Element getElement() {
        return this;
    }

    void setGroup(String group) {
        this.group = group;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }
}

