/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.Properties;
import uk.gov.gchq.koryphe.tuple.Tuple;

public class ElementTuple
implements Tuple<String> {
    public static final String ELEMENT = "ELEMENT";
    public static final String PROPERTIES = "PROPERTIES";
    private Element element;

    public ElementTuple() {
    }

    public ElementTuple(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Object get(String reference) {
        if (ELEMENT.equals(reference)) {
            return this.element;
        }
        if (PROPERTIES.equals(reference)) {
            return this.element.getProperties();
        }
        IdentifierType idType = IdentifierType.fromName(reference);
        if (null == idType) {
            return this.element.getProperty(reference);
        }
        return this.element.getIdentifier(idType);
    }

    public Iterable<Object> values() {
        throw new UnsupportedOperationException("Calling values() is not supported for ElementTuples");
    }

    public void put(String reference, Object value) {
        IdentifierType idType;
        if (ELEMENT.equals(reference)) {
            throw new IllegalArgumentException("You are not allowed to set an entire Element on this ElementTuple");
        }
        if (PROPERTIES.equals(reference)) {
            this.element.copyProperties((Properties)value);
        }
        if (null == (idType = IdentifierType.fromName(reference))) {
            this.element.putProperty(reference, value);
        } else {
            this.element.putIdentifier(idType, value);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ElementTuple objects = (ElementTuple)obj;
        return new EqualsBuilder().append((Object)this.element, (Object)objects.element).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 5).append((Object)this.element).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("element", (Object)this.element).toString();
    }
}

