/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.Properties;
import uk.gov.gchq.gaffer.data.element.id.EntityId;

@JsonPropertyOrder(value={"class", "group", "vertex", "properties"}, alphabetic=true)
public class Entity
extends Element
implements EntityId {
    private static final Logger LOGGER = LoggerFactory.getLogger(Entity.class);
    private static final long serialVersionUID = 2863628004463113755L;
    private Object vertex;

    Entity() {
    }

    public Entity(String group) {
        super(group);
    }

    public Entity(String group, Object vertex) {
        this(group, vertex, null);
    }

    @JsonCreator
    public Entity(@JsonProperty(value="group") String group, @JsonProperty(value="vertex") Object vertex, @JsonProperty(value="properties") Properties properties) {
        super(group, properties);
        this.vertex = vertex;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object vertex) {
        this.vertex = vertex;
    }

    @Override
    public Object getIdentifier(IdentifierType identifierType) {
        switch (identifierType) {
            case GROUP: {
                return this.getGroup();
            }
            case VERTEX: {
                return this.getVertex();
            }
        }
        return null;
    }

    @Override
    public void putIdentifier(IdentifierType identifierType, Object value) {
        switch (identifierType) {
            case GROUP: {
                this.setGroup((String)value);
                break;
            }
            case VERTEX: {
                this.vertex = value;
                break;
            }
            default: {
                LOGGER.error("Unknown identifier type: {} detected.", (Object)identifierType);
            }
        }
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(23, 5).appendSuper(super.hashCode()).append(this.vertex).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return null != obj && obj instanceof Entity && this.equals((Entity)obj);
    }

    public boolean equals(Entity entity) {
        return null != entity && new EqualsBuilder().appendSuper(super.equals(entity)).append(this.vertex, entity.getVertex()).isEquals();
    }

    @Override
    public Entity emptyClone() {
        return new Entity(this.getGroup(), this.getVertex());
    }

    @Override
    public Entity shallowClone() {
        return (Entity)super.shallowClone();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("vertex", this.vertex).appendSuper(super.toString()).build();
    }

    public static class Builder {
        private String group = "UNKNOWN";
        private Object vertex;
        private Properties properties = new Properties();

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder vertex(Object vertex) {
            this.vertex = vertex;
            return this;
        }

        public Builder property(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        public Entity build() {
            return new Entity(this.group, this.vertex, this.properties);
        }
    }
}

