/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import uk.gov.gchq.gaffer.data.element.Edge;
import uk.gov.gchq.gaffer.data.element.ElementValueLoader;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.LazyProperties;
import uk.gov.gchq.gaffer.data.element.id.DirectedType;
import uk.gov.gchq.gaffer.data.element.id.EdgeId;

public class LazyEdge
extends Edge {
    private static final long serialVersionUID = 3950963135470686691L;
    private final Edge edge;
    private final ElementValueLoader valueLoader;
    private final LazyProperties lazyProperties;
    private boolean identifiersLoaded = false;

    public LazyEdge(Edge edge, ElementValueLoader valueLoader) {
        this(edge, valueLoader, new LazyProperties(edge.getProperties(), valueLoader));
    }

    protected LazyEdge(Edge edge, ElementValueLoader valueLoader, LazyProperties lazyProperties) {
        super(edge.getGroup(), null, null, false);
        this.edge = edge;
        this.valueLoader = valueLoader;
        this.lazyProperties = lazyProperties;
    }

    @Override
    public void setIdentifiers(Object source, Object destination, boolean directed, EdgeId.MatchedVertex matchedVertex) {
        this.edge.setIdentifiers(source, destination, directed, matchedVertex);
        this.identifiersLoaded = true;
    }

    @Override
    public Object getProperty(String name) {
        return this.lazyProperties.get(name);
    }

    @Override
    public Object getSource() {
        this.loadIdentifiers();
        return this.edge.getSource();
    }

    @Override
    public Object getDestination() {
        this.loadIdentifiers();
        return this.edge.getDestination();
    }

    @Override
    public boolean isDirected() {
        this.loadIdentifiers();
        return this.edge.isDirected();
    }

    @Override
    public void putIdentifier(IdentifierType name, Object value) {
        this.edge.putIdentifier(name, value);
    }

    @Override
    public void setIdentifiers(Object source, Object destination, DirectedType directedType) {
        this.edge.setIdentifiers(source, destination, directedType);
        this.identifiersLoaded = true;
    }

    @Override
    public void putProperty(String name, Object value) {
        this.lazyProperties.put(name, value);
    }

    @Override
    public String getGroup() {
        return this.edge.getGroup();
    }

    @Override
    public Edge getElement() {
        return this.edge;
    }

    @Override
    public LazyProperties getProperties() {
        return this.lazyProperties;
    }

    @Override
    public Object getIdentifier(IdentifierType identifierType) {
        this.loadIdentifiers();
        return super.getIdentifier(identifierType);
    }

    @Override
    public EdgeId.MatchedVertex getMatchedVertex() {
        this.loadIdentifiers();
        return this.edge.getMatchedVertex();
    }

    @Override
    public boolean equals(Object element) {
        return this.edge.equals(element);
    }

    @Override
    public int hashCode() {
        return this.edge.hashCode();
    }

    private void loadIdentifiers() {
        if (!this.identifiersLoaded) {
            this.valueLoader.loadIdentifiers(this.edge);
            this.identifiersLoaded = true;
        }
    }
}

