/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import uk.gov.gchq.gaffer.data.element.ElementValueLoader;
import uk.gov.gchq.gaffer.data.element.Entity;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.LazyProperties;

public class LazyEntity
extends Entity {
    private static final long serialVersionUID = 8067424362415322354L;
    private final Entity entity;
    private final ElementValueLoader valueLoader;
    private final LazyProperties lazyProperties;
    private boolean identifiersLoaded = false;

    public LazyEntity(Entity entity, ElementValueLoader valueLoader) {
        this(entity, valueLoader, new LazyProperties(entity.getProperties(), valueLoader));
    }

    protected LazyEntity(Entity entity, ElementValueLoader valueLoader, LazyProperties lazyProperties) {
        super(entity.getGroup(), (Object)null);
        this.entity = entity;
        this.valueLoader = valueLoader;
        this.lazyProperties = lazyProperties;
    }

    @Override
    public Object getProperty(String name) {
        return this.lazyProperties.get(name);
    }

    @Override
    public Object getVertex() {
        this.loadIdentifiers();
        return this.entity.getVertex();
    }

    @Override
    public void setVertex(Object vertex) {
        this.entity.setVertex(vertex);
        this.identifiersLoaded = true;
    }

    @Override
    public void putProperty(String name, Object value) {
        this.lazyProperties.put(name, value);
    }

    @Override
    public String getGroup() {
        return this.entity.getGroup();
    }

    @Override
    public Entity getElement() {
        return this.entity;
    }

    @Override
    public LazyProperties getProperties() {
        return this.lazyProperties;
    }

    @Override
    public boolean equals(Object element) {
        return this.entity.equals(element);
    }

    @Override
    public void putIdentifier(IdentifierType name, Object value) {
        this.entity.putIdentifier(name, value);
        this.identifiersLoaded = true;
    }

    @Override
    public int hashCode() {
        return this.entity.hashCode();
    }

    private void loadIdentifiers() {
        if (!this.identifiersLoaded) {
            this.valueLoader.loadIdentifiers(this.entity);
            this.identifiersLoaded = true;
        }
    }
}

