/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.data.element.ElementValueLoader;
import uk.gov.gchq.gaffer.data.element.Properties;

public class LazyProperties
extends Properties {
    private static final long serialVersionUID = 9009552236887934877L;
    private final ElementValueLoader valueLoader;
    private final Set<String> loadedProperties;
    private final Properties properties;

    public LazyProperties(Properties properties, ElementValueLoader valueLoader) {
        this.valueLoader = valueLoader;
        this.properties = properties;
        this.loadedProperties = new HashSet(properties.keySet());
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Object put(String name, Object property) {
        Object result = this.properties.put(name, property);
        this.loadedProperties.add(name);
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ?> newProperties) {
        this.properties.putAll(newProperties);
        this.loadedProperties.addAll(newProperties.keySet());
    }

    @Override
    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Doesn't use any properties in super class")
    public LazyProperties clone() {
        return new LazyProperties(this.properties.clone(), this.valueLoader);
    }

    @Override
    public Object get(Object name) {
        return this.get(name.toString());
    }

    public Object get(String name) {
        Object value;
        if (this.loadedProperties.contains(name)) {
            value = this.properties.get(name);
        } else {
            value = this.valueLoader.getProperty(name, this);
            this.put(name, value);
        }
        return value;
    }

    @Override
    public void clear() {
        this.properties.clear();
        this.loadedProperties.clear();
    }

    @Override
    public Object remove(Object name) {
        Object result = this.properties.remove(name);
        this.loadedProperties.remove(name.toString());
        return result;
    }

    @Override
    public void keepOnly(Collection<String> propertiesToKeep) {
        this.properties.keepOnly(propertiesToKeep);
        this.loadedProperties.removeIf(s -> !propertiesToKeep.contains(s));
    }

    @Override
    public void remove(Collection<String> propertiesToRemove) {
        this.properties.remove(propertiesToRemove);
        this.loadedProperties.removeAll(propertiesToRemove);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        LazyProperties lazy = (LazyProperties)obj;
        return new EqualsBuilder().append((Object)this.properties, (Object)lazy.properties).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(41, 3).append((Object)this.properties).toHashCode();
    }
}

