/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReservedPropertyNames {
    GROUP("group"),
    VERTEX("vertex"),
    SOURCE("src", "source"),
    DESTINATION("dst", "destination"),
    DIRECTED("directed"),
    MATCHED_VERTEX("matchedVertex"),
    ID("id");

    private static final List<ReservedPropertyNames> VALUES;
    private static final List<String> NAMES;
    private final List<String> nameList;

    private ReservedPropertyNames(String ... names) {
        this.nameList = Arrays.stream(names).flatMap(n -> Stream.of(n, n.toUpperCase())).collect(Collectors.toList());
    }

    public static boolean contains(String property) {
        return NAMES.contains(property);
    }

    public Stream<String> getNames() {
        return this.nameList.stream();
    }

    static {
        VALUES = Arrays.asList(ReservedPropertyNames.values());
        NAMES = VALUES.stream().flatMap(ReservedPropertyNames::getNames).collect(Collectors.toList());
    }
}

