/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element.comparison;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.comparison.ElementComparator;

@JsonPropertyOrder(value={"class", "property", "comparator", "groups"}, alphabetic=true)
@SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="This class should not be serialised")
public class ElementPropertyComparator
implements ElementComparator {
    private Comparator comparator;
    public static int count = 0;
    private String property = null;
    private Set<String> groups = Collections.emptySet();
    private boolean reversed;

    @Override
    public int compare(Element e1, Element e2) {
        ++count;
        if (null == e1) {
            if (null == e2) {
                return 0;
            }
            return 1;
        }
        if (null == e2) {
            return -1;
        }
        if (!this.groups.contains(e1.getGroup())) {
            if (!this.groups.contains(e2.getGroup())) {
                return 0;
            }
            return 1;
        }
        if (!this.groups.contains(e2.getGroup())) {
            return -1;
        }
        return this._compare(e1.getProperty(this.property), e2.getProperty(this.property));
    }

    public int _compare(Object val1, Object val2) {
        if (null == val1) {
            if (null == val2) {
                return 0;
            }
            return 1;
        }
        if (null == val2) {
            return -1;
        }
        if (null == this.comparator) {
            if (this.reversed) {
                return ((Comparable)val2).compareTo(val1);
            }
            return ((Comparable)val1).compareTo(val2);
        }
        if (this.reversed) {
            return this.comparator.compare(val2, val1);
        }
        return this.comparator.compare(val1, val2);
    }

    @Override
    public Set<Pair<String, String>> getComparableGroupPropertyPairs() {
        if (null == this.comparator) {
            if (1 == this.groups.size()) {
                return Collections.singleton(new Pair((Object)this.groups.iterator().next(), (Object)this.property));
            }
            HashSet<Pair<String, String>> pairs = new HashSet<Pair<String, String>>(this.groups.size());
            for (String groupName : this.groups) {
                pairs.add((Pair<String, String>)new Pair((Object)groupName, (Object)this.property));
            }
            return pairs;
        }
        return Collections.emptySet();
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public static class Builder {
        private ElementPropertyComparator comparator = new ElementPropertyComparator();

        public ElementPropertyComparator build() {
            return this.comparator;
        }

        public Builder comparator(Comparator comparator) {
            this.comparator.setComparator(comparator);
            return this;
        }

        public Builder groups(String ... group) {
            this.comparator.setGroups(Sets.newHashSet((Object[])group));
            return this;
        }

        public Builder property(String property) {
            this.comparator.setProperty(property);
            return this;
        }

        public Builder reverse(boolean reverse) {
            this.comparator.setReversed(reverse);
            return this;
        }
    }
}

