/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element.function;

import java.util.Collections;
import java.util.List;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.Properties;
import uk.gov.gchq.gaffer.data.element.function.PropertiesTuple;
import uk.gov.gchq.koryphe.tuple.binaryoperator.TupleAdaptedBinaryOperator;
import uk.gov.gchq.koryphe.tuple.binaryoperator.TupleAdaptedBinaryOperatorComposite;

public class ElementAggregator
extends TupleAdaptedBinaryOperatorComposite<String> {
    private final PropertiesTuple stateTuple = new PropertiesTuple();
    private final PropertiesTuple propertiesTuple = new PropertiesTuple();
    private boolean readOnly;

    public Element apply(Element state, Element element) {
        if (null == state) {
            return element;
        }
        this.apply(state.getProperties(), element.getProperties());
        return state;
    }

    public Properties apply(Properties state, Properties properties) {
        if (null == state) {
            return properties;
        }
        this.propertiesTuple.setProperties(properties);
        this.stateTuple.setProperties(state);
        this.apply(this.stateTuple, this.propertiesTuple);
        return state;
    }

    public List<TupleAdaptedBinaryOperator<String, ?>> getComponents() {
        if (this.readOnly) {
            return Collections.unmodifiableList(super.getComponents());
        }
        return super.getComponents();
    }

    public void lock() {
        this.readOnly = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ElementAggregator that = (ElementAggregator)((Object)obj);
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.stateTuple, (Object)that.stateTuple).append((Object)this.propertiesTuple, (Object)that.propertiesTuple).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(59, 13).appendSuper(super.hashCode()).append((Object)this.stateTuple).append((Object)this.propertiesTuple).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("stateTuple", (Object)this.stateTuple).append("propertiesTuple", (Object)this.propertiesTuple).toString();
    }

    public static final class SelectedBuilder {
        private final ElementAggregator aggregator;
        private final TupleAdaptedBinaryOperator<String, Object> current;

        private SelectedBuilder(ElementAggregator aggregator, TupleAdaptedBinaryOperator<String, Object> current) {
            this.aggregator = aggregator;
            this.current = current;
        }

        public Builder execute(BinaryOperator function) {
            this.current.setBinaryOperator(function);
            this.aggregator.getComponents().add(this.current);
            return new Builder(this.aggregator);
        }
    }

    public static class Builder {
        private final ElementAggregator aggregator;

        public Builder() {
            this(new ElementAggregator());
        }

        private Builder(ElementAggregator aggregator) {
            this.aggregator = aggregator;
        }

        public SelectedBuilder select(String ... selection) {
            TupleAdaptedBinaryOperator current = new TupleAdaptedBinaryOperator();
            current.setSelection((Object[])selection);
            return new SelectedBuilder(this.aggregator, current);
        }

        public ElementAggregator build() {
            return this.aggregator;
        }
    }
}

