/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element.function;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.ElementTuple;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.tuple.predicate.TupleAdaptedPredicate;
import uk.gov.gchq.koryphe.tuple.predicate.TupleAdaptedPredicateComposite;

@JsonPropertyOrder(alphabetic=true)
public class ElementFilter
extends TupleAdaptedPredicateComposite<String> {
    private final ElementTuple elementTuple = new ElementTuple();
    private boolean readOnly;

    public boolean test(Element element) {
        this.elementTuple.setElement(element);
        return this.test(this.elementTuple);
    }

    public ValidationResult testWithValidationResult(Element element) {
        ValidationResult result = new ValidationResult();
        this.elementTuple.setElement(element);
        this.components.stream().filter(predicate -> !predicate.test((Object)this.elementTuple)).forEach(predicate -> result.addError(this.getErrorMsg((TupleAdaptedPredicate<String, ?>)predicate)));
        return result;
    }

    private String getErrorMsg(TupleAdaptedPredicate<String, ?> predicate) {
        StringBuilder builder = new StringBuilder();
        builder.append("Filter: ").append(predicate.getPredicate()).append(" returned false for properties: {");
        boolean firstProp = true;
        for (String selection : (String[])predicate.getSelection()) {
            String valueStr;
            Object value = this.elementTuple.get(selection);
            String string = valueStr = null != value ? String.format("<%s>%s", value.getClass().getCanonicalName(), value) : "null";
            if (firstProp) {
                firstProp = false;
            } else {
                builder.append(", ");
            }
            builder.append(selection).append(": ").append(valueStr);
        }
        builder.append("}");
        return builder.toString();
    }

    public List<TupleAdaptedPredicate<String, ?>> getComponents() {
        if (this.readOnly) {
            return Collections.unmodifiableList(super.getComponents());
        }
        return super.getComponents();
    }

    public void lock() {
        this.readOnly = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ElementFilter that = (ElementFilter)((Object)obj);
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.elementTuple, (Object)that.elementTuple).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 53).appendSuper(super.hashCode()).append((Object)this.elementTuple).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("elementTuple", (Object)this.elementTuple).toString();
    }

    public static final class SelectedBuilder {
        private final ElementFilter filter;
        private final TupleAdaptedPredicate<String, Object> current;

        private SelectedBuilder(ElementFilter filter, TupleAdaptedPredicate<String, Object> current) {
            this.filter = filter;
            this.current = current;
        }

        public Builder execute(Predicate function) {
            this.current.setPredicate(function);
            this.filter.getComponents().add(this.current);
            return new Builder(this.filter);
        }
    }

    public static class Builder {
        private final ElementFilter filter;

        public Builder() {
            this(new ElementFilter());
        }

        private Builder(ElementFilter filter) {
            this.filter = filter;
        }

        public SelectedBuilder select(String ... selection) {
            TupleAdaptedPredicate current = new TupleAdaptedPredicate();
            current.setSelection((Object[])selection);
            return new SelectedBuilder(this.filter, current);
        }

        public ElementFilter build() {
            return this.filter;
        }
    }
}

