/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element.id;

import uk.gov.gchq.koryphe.Summary;

@Summary(value="Is the Edge directed?")
public enum DirectedType {
    EITHER,
    DIRECTED,
    UNDIRECTED;


    public static boolean isEither(DirectedType directedType) {
        return null == directedType || EITHER == directedType;
    }

    public static boolean isDirected(DirectedType directedType) {
        return null == directedType || directedType.isDirected();
    }

    public static boolean isUndirected(DirectedType directedType) {
        return null == directedType || directedType.isUndirected();
    }

    public static boolean areCompatible(DirectedType dirType1, DirectedType dirType2) {
        if (DIRECTED == dirType1) {
            return dirType2.isDirected();
        }
        if (UNDIRECTED == dirType1) {
            return dirType2.isUndirected();
        }
        return true;
    }

    public static DirectedType and(DirectedType dirType1, DirectedType dirType2) {
        if (null == dirType1 || EITHER == dirType1) {
            if (null == dirType2) {
                return EITHER;
            }
            return dirType2;
        }
        if (null == dirType2 || EITHER == dirType2) {
            return dirType1;
        }
        if (DIRECTED == dirType1) {
            if (DIRECTED == dirType2) {
                return DIRECTED;
            }
            throw new IllegalArgumentException("Cannot merge incompatible directed types DIRECTED and UNDIRECTED");
        }
        if (UNDIRECTED == dirType2) {
            return UNDIRECTED;
        }
        throw new IllegalArgumentException("Cannot merge incompatible directed types UNDIRECTED and DIRECTED");
    }

    public boolean isDirected() {
        return UNDIRECTED != this;
    }

    public boolean isUndirected() {
        return DIRECTED != this;
    }
}

