/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element.id;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.lang3.builder.EqualsBuilder;
import uk.gov.gchq.gaffer.data.element.id.DirectedType;
import uk.gov.gchq.gaffer.data.element.id.ElementId;
import uk.gov.gchq.gaffer.data.element.id.EntityId;
import uk.gov.gchq.koryphe.Summary;

@JsonFilter(value="filterFieldsByName")
public interface EdgeId
extends ElementId {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT, property="class")
    public Object getSource();

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT, property="class")
    public Object getDestination();

    public DirectedType getDirectedType();

    @JsonIgnore
    default public boolean isDirected() {
        return DirectedType.UNDIRECTED != this.getDirectedType();
    }

    @JsonIgnore
    default public boolean isUndirected() {
        return DirectedType.DIRECTED != this.getDirectedType();
    }

    default public void setIdentifiers(Object source, Object destination, DirectedType directed) {
        this.setIdentifiers(source, destination, directed, this.getMatchedVertex());
    }

    public void setIdentifiers(Object var1, Object var2, DirectedType var3, MatchedVertex var4);

    public MatchedVertex getMatchedVertex();

    @Override
    default public boolean isEqual(ElementId that) {
        return that instanceof EdgeId && this.isEqual((EdgeId)that);
    }

    default public boolean isEqual(EdgeId that) {
        return null != that && new EqualsBuilder().append((Object)this.getDirectedType(), (Object)that.getDirectedType()).append(this.getSource(), that.getSource()).append(this.getDestination(), that.getDestination()).isEquals();
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="If an element is not an Edge it must be an Entity")
    default public ElementId.Matches isRelated(ElementId that) {
        if (that instanceof EdgeId) {
            if (this.isEqual(that)) {
                return ElementId.Matches.BOTH;
            }
            return ElementId.Matches.NONE;
        }
        return this.isRelated((EntityId)that);
    }

    default public ElementId.Matches isRelated(EntityId that) {
        boolean matchesDestination;
        boolean matchesSource;
        boolean bl = null == this.getSource() ? null == that.getVertex() : (matchesSource = this.getSource().equals(that.getVertex()));
        boolean bl2 = null == this.getDestination() ? null == that.getVertex() : (matchesDestination = this.getDestination().equals(that.getVertex()));
        if (matchesSource) {
            if (matchesDestination) {
                return ElementId.Matches.BOTH;
            }
            return ElementId.Matches.SOURCE;
        }
        if (matchesDestination) {
            return ElementId.Matches.DESTINATION;
        }
        return ElementId.Matches.NONE;
    }

    @JsonIgnore
    default public Object getMatchedVertexValue() {
        return MatchedVertex.DESTINATION == this.getMatchedVertex() ? this.getDestination() : this.getSource();
    }

    @JsonIgnore
    default public Object getAdjacentMatchedVertexValue() {
        return MatchedVertex.DESTINATION == this.getMatchedVertex() ? this.getSource() : this.getDestination();
    }

    @Summary(value="Did your seed match the source or the destination of the Edge?")
    public static enum MatchedVertex {
        SOURCE,
        DESTINATION;


        public static boolean isEqual(MatchedVertex matchedVertex1, MatchedVertex matchedVertex2) {
            return matchedVertex1 == matchedVertex2 || null == matchedVertex1 && SOURCE == matchedVertex2 || null == matchedVertex2 && SOURCE == matchedVertex1;
        }
    }
}

