/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.element.id;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import uk.gov.gchq.gaffer.data.element.id.EdgeId;
import uk.gov.gchq.gaffer.data.element.id.ElementId;

public interface EntityId
extends ElementId {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT, property="class")
    public Object getVertex();

    public void setVertex(Object var1);

    @Override
    default public boolean isEqual(ElementId that) {
        return that instanceof EntityId && this.isEqual((EntityId)that);
    }

    default public boolean isEqual(EntityId that) {
        return Objects.equals(this.getVertex(), that.getVertex());
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="If an element is not an Edge it must be an Edge")
    default public ElementId.Matches isRelated(ElementId that) {
        if (that instanceof EntityId) {
            if (this.isEqual(that)) {
                return ElementId.Matches.VERTEX;
            }
            return ElementId.Matches.NONE;
        }
        return this.isRelated((EdgeId)that);
    }

    default public ElementId.Matches isRelated(EdgeId that) {
        boolean matchesDestination;
        boolean matchesSource;
        boolean bl = null == this.getVertex() ? null == that.getSource() : (matchesSource = this.getVertex().equals(that.getSource()));
        boolean bl2 = null == this.getVertex() ? null == that.getDestination() : (matchesDestination = this.getVertex().equals(that.getDestination()));
        if (matchesSource) {
            if (matchesDestination) {
                return ElementId.Matches.BOTH;
            }
            return ElementId.Matches.SOURCE;
        }
        if (matchesDestination) {
            return ElementId.Matches.DESTINATION;
        }
        return ElementId.Matches.NONE;
    }
}

