/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.elementdefinition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.elementdefinition.ElementDefinition;
import uk.gov.gchq.gaffer.data.elementdefinition.exception.SchemaException;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;

public abstract class ElementDefinitions<ENTITY_DEF extends ElementDefinition, EDGE_DEF extends ElementDefinition> {
    private Map<String, EDGE_DEF> edges = new HashMap<String, EDGE_DEF>();
    private Map<String, ENTITY_DEF> entities = new HashMap<String, ENTITY_DEF>();

    protected ElementDefinitions() {
    }

    public byte[] toJson(boolean prettyPrint, String ... fieldsToExclude) throws SchemaException {
        try {
            return JSONSerialiser.serialise((Object)this, (boolean)prettyPrint, (String[])fieldsToExclude);
        }
        catch (SerialisationException e) {
            throw new SchemaException(e.getMessage(), e);
        }
    }

    public ElementDefinition getElement(String group) {
        return this.isEntity(group) ? this.getEntity(group) : this.getEdge(group);
    }

    public EDGE_DEF getEdge(String group) {
        return (EDGE_DEF)((ElementDefinition)this.edges.get(group));
    }

    public ENTITY_DEF getEntity(String group) {
        return (ENTITY_DEF)((ElementDefinition)this.entities.get(group));
    }

    public boolean isEntity(String group) {
        return this.entities.containsKey(group);
    }

    public boolean isEdge(String group) {
        return this.edges.containsKey(group);
    }

    @JsonIgnore
    public Set<String> getEdgeGroups() {
        return null != this.edges ? this.edges.keySet() : Collections.emptySet();
    }

    @JsonIgnore
    public Set<String> getEntityGroups() {
        return null != this.entities ? this.entities.keySet() : Collections.emptySet();
    }

    @JsonIgnore
    public Set<String> getGroups() {
        Set<String> entityGroups = this.getEntityGroups();
        Set<String> edgeGroups = this.getEdgeGroups();
        HashSet<String> groups = new HashSet<String>(entityGroups.size() + edgeGroups.size());
        groups.addAll(entityGroups);
        groups.addAll(edgeGroups);
        return groups;
    }

    @JsonIgnore
    public boolean hasEntities() {
        return null != this.entities && !this.entities.isEmpty();
    }

    @JsonIgnore
    public boolean hasEdges() {
        return null != this.edges && !this.edges.isEmpty();
    }

    @JsonIgnore
    public boolean hasGroups() {
        return this.hasEntities() || this.hasEdges();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, EDGE_DEF> getEdges() {
        return this.edges;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, ENTITY_DEF> getEntities() {
        return this.entities;
    }

    protected void setEdges(Map<String, EDGE_DEF> edges) {
        this.edges = edges;
    }

    protected void setEntities(Map<String, ENTITY_DEF> entities) {
        this.entities = entities;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ElementDefinitions that = (ElementDefinitions)obj;
        return new EqualsBuilder().append(this.edges, that.edges).append(this.entities, that.entities).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 5).append(this.edges).append(this.entities).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("edges", this.edges).append("entities", this.entities).toString();
    }

    protected void lock() {
        this.edges = Collections.unmodifiableMap(this.edges);
        this.entities = Collections.unmodifiableMap(this.entities);
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="set")
    public static abstract class BaseBuilder<ELEMENT_DEFS extends ElementDefinitions<ENTITY_DEF, EDGE_DEF>, ENTITY_DEF extends ElementDefinition, EDGE_DEF extends ElementDefinition, CHILD_CLASS extends BaseBuilder<ELEMENT_DEFS, ENTITY_DEF, EDGE_DEF, ?>> {
        private ELEMENT_DEFS elementDefs;

        protected BaseBuilder(ELEMENT_DEFS elementDefs) {
            this.elementDefs = elementDefs;
        }

        public CHILD_CLASS edge(String group, EDGE_DEF edgeDef) {
            ((ElementDefinitions)this.elementDefs).getEdges().put(group, edgeDef);
            return this.self();
        }

        @JsonSetter(value="edges")
        public CHILD_CLASS edges(Map<String, EDGE_DEF> edges) {
            ((ElementDefinitions)this.elementDefs).getEdges().clear();
            return this.addEdges(edges);
        }

        public CHILD_CLASS addEdges(Map<String, EDGE_DEF> edges) {
            if (null != edges) {
                ((ElementDefinitions)this.elementDefs).getEdges().putAll(edges);
            }
            return this.self();
        }

        public CHILD_CLASS entity(String group, ENTITY_DEF entityDef) {
            if (null == entityDef) {
                throw new IllegalArgumentException("Entity definition is required");
            }
            ((ElementDefinitions)this.elementDefs).getEntities().put(group, entityDef);
            return this.self();
        }

        @JsonSetter(value="entities")
        public CHILD_CLASS entities(Map<String, ENTITY_DEF> entities) {
            ((ElementDefinitions)this.elementDefs).getEntities().clear();
            return this.addEntities(entities);
        }

        public CHILD_CLASS addEntities(Map<String, ENTITY_DEF> entities) {
            if (null != entities) {
                ((ElementDefinitions)this.elementDefs).getEntities().putAll(entities);
            }
            return this.self();
        }

        public CHILD_CLASS removeEdges(Predicate<Map.Entry<String, EDGE_DEF>> filter) {
            ((ElementDefinitions)this.elementDefs).getEdges().entrySet().removeIf(filter);
            return this.self();
        }

        public CHILD_CLASS removeEntities(Predicate<Map.Entry<String, ENTITY_DEF>> filter) {
            ((ElementDefinitions)this.elementDefs).getEntities().entrySet().removeIf(filter);
            return this.self();
        }

        public CHILD_CLASS json(Class<? extends ELEMENT_DEFS> clazz, Path ... filePaths) throws SchemaException {
            return this.json(clazz, (Object[])filePaths);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CHILD_CLASS json(Class<? extends ELEMENT_DEFS> clazz, InputStream ... inputStreams) throws SchemaException {
            try {
                CHILD_CLASS CHILD_CLASS = this.json(clazz, (Object[])inputStreams);
                return CHILD_CLASS;
            }
            finally {
                if (null != inputStreams) {
                    for (InputStream inputStream : inputStreams) {
                        CloseableUtil.close((AutoCloseable)inputStream);
                    }
                }
            }
        }

        public CHILD_CLASS json(Class<? extends ELEMENT_DEFS> clazz, byte[] ... jsonBytes) throws SchemaException {
            return this.json(clazz, (Object[])jsonBytes);
        }

        public CHILD_CLASS json(Class<? extends ELEMENT_DEFS> clazz, Object[] jsonItems) throws SchemaException {
            if (null != jsonItems) {
                for (Object jsonItem : jsonItems) {
                    try {
                        if (jsonItem instanceof InputStream) {
                            this.merge((ElementDefinitions)JSONSerialiser.deserialise((InputStream)((InputStream)jsonItem), clazz));
                            continue;
                        }
                        if (jsonItem instanceof Path) {
                            Path path = (Path)jsonItem;
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                for (Path filePath : Files.newDirectoryStream(path)) {
                                    this.merge((ElementDefinitions)JSONSerialiser.deserialise((byte[])Files.readAllBytes(filePath), clazz));
                                }
                                continue;
                            }
                            this.merge((ElementDefinitions)JSONSerialiser.deserialise((byte[])Files.readAllBytes(path), clazz));
                            continue;
                        }
                        this.merge((ElementDefinitions)JSONSerialiser.deserialise((byte[])((byte[])jsonItem), clazz));
                    }
                    catch (IOException e) {
                        throw new SchemaException("Failed to load element definitions from bytes", e);
                    }
                }
            }
            return this.self();
        }

        protected abstract CHILD_CLASS merge(ELEMENT_DEFS var1);

        public ELEMENT_DEFS build() {
            ((ElementDefinitions)this.elementDefs).lock();
            return this.elementDefs;
        }

        protected ELEMENT_DEFS getElementDefs() {
            return this.elementDefs;
        }

        protected void setElementDefs(ELEMENT_DEFS elementDefs) {
            this.elementDefs = elementDefs;
        }

        protected abstract CHILD_CLASS self();
    }
}

