/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.elementdefinition.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import uk.gov.gchq.gaffer.commonutil.Required;
import uk.gov.gchq.gaffer.data.elementdefinition.exception.SchemaException;
import uk.gov.gchq.gaffer.data.elementdefinition.view.View;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"class", "name", "edges", "entities"}, alphabetic=true)
public class NamedView
extends View {
    @Required
    private String name = "";
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @JsonIgnore
    private List<String> mergedNamedViewNames = new ArrayList<String>();

    public void setName(String viewName) {
        this.name = viewName;
    }

    public String getName() {
        return this.name;
    }

    public void setMergedNamedViewNames(List<String> mergedNamedViewNames) {
        if (mergedNamedViewNames != null) {
            if (this.mergedNamedViewNames != null) {
                this.mergedNamedViewNames.addAll(mergedNamedViewNames);
            } else {
                this.mergedNamedViewNames = mergedNamedViewNames;
            }
        }
    }

    public List<String> getMergedNamedViewNames() {
        return this.mergedNamedViewNames;
    }

    public void setParameters(Map<String, Object> parameters) {
        if (parameters != null) {
            if (null != this.parameters) {
                this.parameters.putAll(parameters);
            } else {
                this.parameters = parameters;
            }
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean canMerge(View addingView, View srcView) {
        return !(addingView instanceof NamedView) || srcView instanceof NamedView || ((NamedView)addingView).getName() == null || ((NamedView)addingView).getName().isEmpty();
    }

    @Override
    public void expandGlobalDefinitions() {
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder
    extends BaseBuilder<Builder> {
        public Builder() {
        }

        public Builder(NamedView namedView) {
            super(namedView);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class BaseBuilder<CHILD_CLASS extends BaseBuilder<?>>
    extends View.BaseBuilder<CHILD_CLASS> {
        public BaseBuilder() {
            this(new NamedView());
        }

        public BaseBuilder(NamedView namedView) {
            super(namedView);
        }

        public CHILD_CLASS name(String name) {
            this.getElementDefs().setName(name);
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS parameters(Map<String, Object> parameters) {
            this.getElementDefs().setParameters(parameters);
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        @Override
        @JsonIgnore
        public CHILD_CLASS json(InputStream ... inputStreams) throws SchemaException {
            return (CHILD_CLASS)((BaseBuilder)this.json(NamedView.class, inputStreams));
        }

        @Override
        @JsonIgnore
        public CHILD_CLASS json(Path ... filePaths) throws SchemaException {
            return (CHILD_CLASS)((BaseBuilder)this.json(NamedView.class, filePaths));
        }

        @Override
        @JsonIgnore
        public CHILD_CLASS json(byte[] ... jsonBytes) throws SchemaException {
            return (CHILD_CLASS)((BaseBuilder)this.json(NamedView.class, jsonBytes));
        }

        @Override
        public CHILD_CLASS merge(View view) {
            if (null != view) {
                if (view instanceof NamedView) {
                    NamedView namedViewInstance = (NamedView)view;
                    if (StringUtils.isNotEmpty((CharSequence)namedViewInstance.getName())) {
                        if (StringUtils.isEmpty((CharSequence)((BaseBuilder)this.self()).getElementDefs().getName())) {
                            ((BaseBuilder)this.self()).name(namedViewInstance.getName());
                        } else if (!((BaseBuilder)this.self()).getElementDefs().getName().equals(((NamedView)view).getName())) {
                            ((BaseBuilder)this.self()).getElementDefs().getMergedNamedViewNames().add(namedViewInstance.getName());
                        }
                    }
                    if (CollectionUtils.isNotEmpty(namedViewInstance.getMergedNamedViewNames())) {
                        ((BaseBuilder)this.self()).getElementDefs().setMergedNamedViewNames(namedViewInstance.getMergedNamedViewNames());
                    }
                    if (MapUtils.isNotEmpty(namedViewInstance.getParameters())) {
                        ((BaseBuilder)this.self()).parameters(namedViewInstance.getParameters());
                    }
                }
                super.merge(view);
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        @Override
        public NamedView build() {
            if (((BaseBuilder)this.self()).getElementDefs().getName() == null || ((BaseBuilder)this.self()).getElementDefs().getName().isEmpty()) {
                throw new IllegalArgumentException("Name must be set");
            }
            return (NamedView)super.build();
        }

        @Override
        protected NamedView getElementDefs() {
            return (NamedView)super.getElementDefs();
        }
    }
}

