/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.elementdefinition.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.StringUtil;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.elementdefinition.view.View;
import uk.gov.gchq.gaffer.data.elementdefinition.view.ViewParameterDetail;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;

@JsonPropertyOrder(value={"name", "description", "creatorId", "writeAccessRoles", "parameters", "view"}, alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class NamedViewDetail
implements Serializable {
    private static final long serialVersionUID = -8354836093398004122L;
    private static final String CHARSET_NAME = "UTF-8";
    private String name;
    private String view;
    private String description;
    private String creatorId;
    private List<String> writeAccessRoles;
    private Map<String, ViewParameterDetail> parameters = Maps.newHashMap();

    public NamedViewDetail() {
    }

    public NamedViewDetail(String name, String view, String description, Map<String, ViewParameterDetail> parameters) {
        this.setName(name);
        this.setView(view);
        this.setDescription(description);
        this.creatorId = null;
        this.writeAccessRoles = new ArrayList<String>();
        this.setParameters(parameters);
    }

    public NamedViewDetail(String name, String view, String description, String userId, List<String> writers, Map<String, ViewParameterDetail> parameters) {
        this.setName(name);
        this.setView(view);
        this.setDescription(description);
        this.creatorId = userId;
        this.writeAccessRoles = writers;
        this.setParameters(parameters);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        this.name = name;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        if (null == view) {
            throw new IllegalArgumentException("View cannot be null");
        }
        this.view = view;
    }

    public void setView(View view) {
        if (null != view) {
            try {
                this.view = new String(JSONSerialiser.serialise((Object)view, (String[])new String[0]), Charset.forName(CHARSET_NAME));
            }
            catch (SerialisationException se) {
                throw new IllegalArgumentException(se.getMessage());
            }
        } else {
            throw new IllegalArgumentException("View cannot be null");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public List<String> getWriteAccessRoles() {
        return this.writeAccessRoles;
    }

    public boolean hasWriteAccess(String userId, Set<String> opAuths, String adminAuth) {
        return this.hasWriteAccess(userId, opAuths, this.writeAccessRoles, adminAuth);
    }

    public Map<String, ViewParameterDetail> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, ViewParameterDetail> parameters) {
        if (parameters != null) {
            if (null != this.parameters) {
                this.parameters.putAll(parameters);
            } else {
                this.parameters = parameters;
            }
        }
    }

    @JsonIgnore
    public View getViewWithDefaultParams() {
        View view;
        String viewStringWithDefaults = this.view;
        if (null != this.parameters) {
            for (Map.Entry<String, ViewParameterDetail> parameterDetailPair : this.parameters.entrySet()) {
                String paramKey = parameterDetailPair.getKey();
                try {
                    viewStringWithDefaults = viewStringWithDefaults.replace(this.buildParamNameString(paramKey), StringUtil.toString((byte[])JSONSerialiser.serialise((Object)parameterDetailPair.getValue().getDefaultValue(), (String[])new String[0])));
                }
                catch (SerialisationException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        }
        try {
            view = (View)JSONSerialiser.deserialise((byte[])StringUtil.toBytes((String)viewStringWithDefaults), View.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return view;
    }

    public View getView(Map<String, Object> executionParams) {
        View view;
        String viewString = this.view;
        for (Map.Entry<String, ViewParameterDetail> entry : this.parameters.entrySet()) {
            Object paramValueObj;
            String paramKey = entry.getKey();
            ViewParameterDetail paramDetail = entry.getValue();
            if (null != executionParams && executionParams.keySet().contains(paramKey)) {
                paramValueObj = executionParams.get(paramKey);
            } else if (null != paramDetail.getDefaultValue() && !paramDetail.isRequired()) {
                paramValueObj = paramDetail.getDefaultValue();
            } else {
                throw new IllegalArgumentException("Missing parameter " + paramKey + " with no default");
            }
            try {
                viewString = viewString.replace(this.buildParamNameString(paramKey), StringUtil.toString((byte[])JSONSerialiser.serialise((Object)paramValueObj, (String[])new String[0])));
            }
            catch (SerialisationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        try {
            view = (View)JSONSerialiser.deserialise((byte[])StringUtil.toBytes((String)viewString), View.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return view;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedViewDetail op = (NamedViewDetail)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)op.name).append((Object)this.view, (Object)op.view).append((Object)this.description, (Object)op.description).append((Object)this.creatorId, (Object)op.creatorId).append(this.writeAccessRoles, op.writeAccessRoles).append(this.parameters, op.parameters).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(71, 3).append((Object)this.name).append((Object)this.view).append((Object)this.description).append((Object)this.creatorId).append(this.writeAccessRoles).append(this.parameters).hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("name", (Object)this.name).append("view", (Object)this.view).append("description", (Object)this.description).append("creatorId", (Object)this.creatorId).append("writeAccessRoles", this.writeAccessRoles).append("parameters", this.parameters).toString();
    }

    private String buildParamNameString(String paramKey) {
        return "\"${" + paramKey + "}\"";
    }

    private boolean hasWriteAccess(String userId, Set<String> opAuths, List<String> roles, String adminAuth) {
        if (null != roles) {
            for (String role : roles) {
                if (!opAuths.contains(role)) continue;
                return true;
            }
        }
        if (StringUtils.isNotBlank((String)adminAuth) && opAuths.contains(adminAuth)) {
            return true;
        }
        return null == this.creatorId || userId.equals(this.creatorId);
    }

    public static final class Builder {
        private String name;
        private String view;
        private String description;
        private String creatorId;
        private List<String> writers = new ArrayList<String>();
        private Map<String, ViewParameterDetail> parameters;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder view(String view) {
            if (null != view) {
                this.view = view;
                return this;
            }
            throw new IllegalArgumentException("View cannot be null");
        }

        public Builder view(View view) {
            if (null != view) {
                try {
                    this.view = new String(JSONSerialiser.serialise((Object)view, (String[])new String[0]), Charset.forName(NamedViewDetail.CHARSET_NAME));
                    return this;
                }
                catch (SerialisationException se) {
                    throw new IllegalArgumentException(se.getMessage());
                }
            }
            throw new IllegalArgumentException("View cannot be null");
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public Builder writers(List<String> writers) {
            this.writers = writers;
            return this;
        }

        public Builder parameters(Map<String, ViewParameterDetail> parameters) {
            this.parameters = parameters;
            return this;
        }

        public NamedViewDetail build() {
            return new NamedViewDetail(this.name, this.view, this.description, this.creatorId, this.writers, this.parameters);
        }
    }
}

