/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.elementdefinition.view;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.elementdefinition.ElementDefinitions;
import uk.gov.gchq.gaffer.data.elementdefinition.exception.SchemaException;
import uk.gov.gchq.gaffer.data.elementdefinition.view.GlobalViewElementDefinition;
import uk.gov.gchq.gaffer.data.elementdefinition.view.ViewElementDefinition;
import uk.gov.gchq.koryphe.serialisation.json.JsonSimpleClassName;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="class", defaultImpl=View.class)
@JsonPropertyOrder(value={"class", "edges", "entities"}, alphabetic=true)
@JsonSimpleClassName(includeSubtypes=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class View
extends ElementDefinitions<ViewElementDefinition, ViewElementDefinition>
implements Cloneable {
    private List<GlobalViewElementDefinition> globalElements;
    private List<GlobalViewElementDefinition> globalEntities;
    private List<GlobalViewElementDefinition> globalEdges;
    private Map<String, String> config = new HashMap<String, String>();
    private boolean allEntities = false;
    private boolean allEdges = false;

    public static View fromJson(InputStream inputStream) throws SchemaException {
        return ((Builder)new Builder().json(inputStream)).build();
    }

    public static View fromJson(Path filePath) throws SchemaException {
        return ((Builder)new Builder().json(filePath)).build();
    }

    public static View fromJson(byte[] jsonBytes) throws SchemaException {
        return ((Builder)new Builder().json(new byte[][]{jsonBytes})).build();
    }

    public byte[] toCompactJson() throws SchemaException {
        return this.toJson(false, new String[0]);
    }

    @Override
    public String toString() {
        try {
            return new ToStringBuilder((Object)this).append((Object)new String(this.toJson(true, new String[0]), "UTF-8")).build();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ViewElementDefinition getElement(String group) {
        return (ViewElementDefinition)super.getElement(group);
    }

    public Set<String> getElementGroupBy(String group) {
        ViewElementDefinition viewElementDef = (ViewElementDefinition)super.getElement(group);
        if (null == viewElementDef) {
            return null;
        }
        return viewElementDef.getGroupBy();
    }

    public boolean isAllEntities() {
        return this.allEntities;
    }

    public void setAllEntities(boolean allEntities) {
        this.allEntities = allEntities;
    }

    public boolean isAllEdges() {
        return this.allEdges;
    }

    public void setAllEdges(boolean allEdges) {
        this.allEdges = allEdges;
    }

    public List<GlobalViewElementDefinition> getGlobalElements() {
        return this.globalElements;
    }

    public List<GlobalViewElementDefinition> getGlobalEntities() {
        return this.globalEntities;
    }

    public List<GlobalViewElementDefinition> getGlobalEdges() {
        return this.globalEdges;
    }

    public boolean hasPreAggregationFilters() {
        return this.hasFilters(ViewElementDefinition::hasPreAggregationFilters);
    }

    public boolean hasPostAggregationFilters() {
        return this.hasFilters(ViewElementDefinition::hasPostAggregationFilters);
    }

    public boolean hasPostTransformFilters() {
        return this.hasFilters(ViewElementDefinition::hasPostTransformFilters);
    }

    public boolean hasEntityFilters() {
        return this.hasEntityFilters(ViewElementDefinition::hasPostAggregationFilters) || this.hasEntityFilters(ViewElementDefinition::hasPostTransformFilters) || this.hasEntityFilters(ViewElementDefinition::hasPreAggregationFilters);
    }

    public boolean hasEdgeFilters() {
        return this.hasEdgeFilters(ViewElementDefinition::hasPostAggregationFilters) || this.hasEdgeFilters(ViewElementDefinition::hasPostTransformFilters) || this.hasEdgeFilters(ViewElementDefinition::hasPreAggregationFilters);
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Only inherits from Object")
    public View clone() {
        return View.fromJson(this.toJson(false, new String[0]));
    }

    @Override
    protected void lock() {
        super.lock();
        if (null != this.globalElements) {
            this.globalElements = Collections.unmodifiableList(this.globalElements);
        }
        if (null != this.globalEntities) {
            this.globalEntities = Collections.unmodifiableList(this.globalEntities);
        }
        if (null != this.globalEdges) {
            this.globalEdges = Collections.unmodifiableList(this.globalEdges);
        }
    }

    public void expandGlobalDefinitions() {
        if (null != this.globalEntities && !this.globalEntities.isEmpty()) {
            this.setEntities(this.expandGlobalDefinitions(this.getEntities(), this.getEntityGroups(), this.globalEntities, false));
            this.globalEntities = null;
        }
        if (null != this.globalEdges && !this.globalEdges.isEmpty()) {
            this.setEdges(this.expandGlobalDefinitions(this.getEdges(), this.getEdgeGroups(), this.globalEdges, false));
            this.globalEdges = null;
        }
        if (null != this.globalElements && !this.globalElements.isEmpty()) {
            this.setEntities(this.expandGlobalDefinitions(this.getEntities(), this.getEntityGroups(), this.globalElements, true));
            this.setEdges(this.expandGlobalDefinitions(this.getEdges(), this.getEdgeGroups(), this.globalElements, true));
            this.globalElements = null;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getConfig() {
        return this.config;
    }

    public void addConfig(String key, String value) {
        if (!this.config.containsKey(key)) {
            this.config.put(key, value);
        }
    }

    public String getConfig(String key) {
        return this.config.get(key);
    }

    private Map<String, ViewElementDefinition> expandGlobalDefinitions(Map<String, ViewElementDefinition> elements, Set<String> groups, List<GlobalViewElementDefinition> globalElements, boolean skipMissingGroups) {
        LinkedHashMap<String, ViewElementDefinition> newElements = new LinkedHashMap<String, ViewElementDefinition>();
        for (GlobalViewElementDefinition globalViewElementDefinition : globalElements) {
            Set<String> globalGroups;
            if (null != globalViewElementDefinition.groups) {
                globalGroups = new HashSet<String>(globalViewElementDefinition.groups);
                boolean hasMissingGroups = globalGroups.retainAll(groups);
                if (hasMissingGroups && !skipMissingGroups) {
                    HashSet<String> missingGroups = new HashSet<String>(globalViewElementDefinition.groups);
                    missingGroups.removeAll(groups);
                    throw new IllegalArgumentException("A global element definition is invalid, these groups do not exist: " + missingGroups);
                }
            } else {
                globalGroups = groups;
            }
            for (String group : globalGroups) {
                ViewElementDefinition.Builder builder = new ViewElementDefinition.Builder();
                if (newElements.containsKey(group)) {
                    builder.merge((ViewElementDefinition)newElements.get(group));
                }
                builder.merge(globalViewElementDefinition.clone());
                newElements.put(group, builder.build());
            }
        }
        if (null != elements) {
            for (Map.Entry entry : elements.entrySet()) {
                String group = (String)entry.getKey();
                if (newElements.containsKey(group)) {
                    newElements.put(group, ((ViewElementDefinition.Builder)((ViewElementDefinition.Builder)new ViewElementDefinition.Builder().merge((ViewElementDefinition)newElements.get(group))).merge((ViewElementDefinition)entry.getValue())).build());
                    continue;
                }
                newElements.put(group, (ViewElementDefinition)entry.getValue());
            }
        }
        return Collections.unmodifiableMap(newElements);
    }

    private boolean hasFilters(Function<ViewElementDefinition, Boolean> hasFilters) {
        return this.hasEdgeFilters(hasFilters) || this.hasEntityFilters(hasFilters);
    }

    private boolean hasEntityFilters(Function<ViewElementDefinition, Boolean> hasEntityFilters) {
        for (ViewElementDefinition value : this.getEntities().values()) {
            if (null == value || !hasEntityFilters.apply(value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean hasEdgeFilters(Function<ViewElementDefinition, Boolean> hasEdgeFilters) {
        for (ViewElementDefinition value : this.getEdges().values()) {
            if (null == value || !hasEdgeFilters.apply(value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean canMerge(View addingView, View srcView) {
        return !(addingView instanceof View) || srcView instanceof View;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        View view = (View)obj;
        return new EqualsBuilder().appendSuper(super.equals(view)).append(this.globalElements, view.getGlobalElements()).append(this.globalEntities, view.getGlobalEntities()).append(this.globalEdges, view.getGlobalEdges()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.globalElements).append(this.globalEntities).append(this.globalEdges).toHashCode();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonGetter(value="class")
    public String getClassName() {
        return View.class.equals(this.getClass()) ? null : this.getClass().getName();
    }

    @JsonSetter(value="class")
    void setClassName(String className) {
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder
    extends BaseBuilder<Builder> {
        public Builder() {
        }

        public Builder(View view) {
            this();
            this.merge(view);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class BaseBuilder<CHILD_CLASS extends BaseBuilder<?>>
    extends ElementDefinitions.BaseBuilder<View, ViewElementDefinition, ViewElementDefinition, CHILD_CLASS> {
        public BaseBuilder() {
            super(new View());
        }

        protected BaseBuilder(View view) {
            super(view);
        }

        public CHILD_CLASS entity(String group) {
            return this.entity(group, new ViewElementDefinition());
        }

        @Override
        public CHILD_CLASS entity(String group, ViewElementDefinition entityDef) {
            return (CHILD_CLASS)((BaseBuilder)super.entity(group, null != entityDef ? entityDef : new ViewElementDefinition()));
        }

        @JsonIgnore
        public CHILD_CLASS entities(Collection<String> groups) {
            if (null != groups) {
                for (String group : groups) {
                    this.entity(group);
                }
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS allEntities(boolean allEntites) {
            this.getThisView().allEntities = allEntites;
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS edge(String group) {
            return this.edge(group, new ViewElementDefinition());
        }

        @Override
        public CHILD_CLASS edge(String group, ViewElementDefinition edgeDef) {
            return (CHILD_CLASS)((BaseBuilder)super.edge(group, null != edgeDef ? edgeDef : new ViewElementDefinition()));
        }

        public CHILD_CLASS edges(Collection<String> groups) {
            if (null != groups) {
                for (String group : groups) {
                    this.edge(group);
                }
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS allEdges(boolean allEdges) {
            this.getThisView().allEdges = allEdges;
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS config(String key, String value) {
            this.getThisView().config.put(key, value);
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        @JsonSetter(value="config")
        public CHILD_CLASS config(Map<String, String> config) {
            if (null != config) {
                this.getThisView().config.putAll(config);
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS globalElements(GlobalViewElementDefinition ... globalElements) {
            if (null != globalElements && globalElements.length > 0) {
                if (null == this.getThisView().globalElements) {
                    this.getThisView().globalElements = new ArrayList();
                }
                Collections.addAll(this.getThisView().globalElements, globalElements);
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS globalEntities(GlobalViewElementDefinition ... globalEntities) {
            if (null != globalEntities && globalEntities.length > 0) {
                if (null == this.getThisView().globalEntities) {
                    this.getThisView().globalEntities = new ArrayList();
                }
                Collections.addAll(this.getThisView().globalEntities, globalEntities);
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS globalEdges(GlobalViewElementDefinition ... globalEdges) {
            if (null != globalEdges && globalEdges.length > 0) {
                if (null == this.getThisView().globalEdges) {
                    this.getThisView().globalEdges = new ArrayList();
                }
                Collections.addAll(this.getThisView().globalEdges, globalEdges);
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        @JsonIgnore
        public CHILD_CLASS json(InputStream ... inputStreams) throws SchemaException {
            return (CHILD_CLASS)((BaseBuilder)this.json(View.class, inputStreams));
        }

        @JsonIgnore
        public CHILD_CLASS json(Path ... filePaths) throws SchemaException {
            return (CHILD_CLASS)((BaseBuilder)this.json(View.class, filePaths));
        }

        @JsonIgnore
        public CHILD_CLASS json(byte[] ... jsonBytes) throws SchemaException {
            return (CHILD_CLASS)((BaseBuilder)this.json(View.class, jsonBytes));
        }

        @Override
        @JsonIgnore
        public CHILD_CLASS merge(View view) {
            if (null != view) {
                ViewElementDefinition mergedElementDef;
                if (!this.getThisView().canMerge(view, this.getThisView()) || !view.canMerge(view, this.getThisView())) {
                    throw new IllegalArgumentException("A " + view.getClass().getSimpleName() + " cannot be merged into a " + this.getThisView().getClass().getSimpleName());
                }
                if (this.getThisView().getEntities().isEmpty()) {
                    this.getThisView().getEntities().putAll(view.getEntities());
                } else {
                    for (Map.Entry entry : view.getEntities().entrySet()) {
                        if (!this.getThisView().getEntities().containsKey(entry.getKey())) {
                            this.entity(entry.getKey(), (ViewElementDefinition)entry.getValue());
                            continue;
                        }
                        mergedElementDef = ((ViewElementDefinition.Builder)((ViewElementDefinition.Builder)new ViewElementDefinition.Builder().merge((ViewElementDefinition)this.getThisView().getEntities().get(entry.getKey()))).merge((ViewElementDefinition)entry.getValue())).build();
                        this.getThisView().getEntities().put(entry.getKey(), mergedElementDef);
                    }
                }
                if (this.getThisView().getEdges().isEmpty()) {
                    this.getThisView().getEdges().putAll(view.getEdges());
                } else {
                    for (Map.Entry<String, Object> entry : view.getEdges().entrySet()) {
                        if (!this.getThisView().getEdges().containsKey(entry.getKey())) {
                            this.edge(entry.getKey(), (ViewElementDefinition)entry.getValue());
                            continue;
                        }
                        mergedElementDef = ((ViewElementDefinition.Builder)((ViewElementDefinition.Builder)new ViewElementDefinition.Builder().merge((ViewElementDefinition)this.getThisView().getEdges().get(entry.getKey()))).merge((ViewElementDefinition)entry.getValue())).build();
                        this.getThisView().getEdges().put(entry.getKey(), mergedElementDef);
                    }
                }
                if (null != view.globalElements) {
                    if (null == this.getThisView().globalElements) {
                        this.getThisView().globalElements = new ArrayList();
                    }
                    this.getThisView().globalElements.addAll(view.globalElements);
                }
                if (null != view.globalEntities) {
                    if (null == this.getThisView().globalEntities) {
                        this.getThisView().globalEntities = new ArrayList();
                    }
                    this.getThisView().globalEntities.addAll(view.globalEntities);
                }
                if (null != view.globalEdges) {
                    if (null == this.getThisView().globalEdges) {
                        this.getThisView().globalEdges = new ArrayList();
                    }
                    this.getThisView().globalEdges.addAll(view.globalEdges);
                }
                if (null != view.config) {
                    this.getThisView().config.putAll(view.config);
                }
            }
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        public CHILD_CLASS expandGlobalDefinitions() {
            this.getThisView().expandGlobalDefinitions();
            return (CHILD_CLASS)((BaseBuilder)this.self());
        }

        @Override
        public View build() {
            return (View)super.build();
        }

        private View getThisView() {
            return (View)this.getElementDefs();
        }
    }
}

