/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.elementdefinition.view;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.data.element.function.ElementAggregator;
import uk.gov.gchq.gaffer.data.element.function.ElementFilter;
import uk.gov.gchq.gaffer.data.element.function.ElementTransformer;
import uk.gov.gchq.gaffer.data.elementdefinition.ElementDefinition;
import uk.gov.gchq.gaffer.data.elementdefinition.exception.SchemaException;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;
import uk.gov.gchq.koryphe.tuple.function.TupleAdaptedFunction;
import uk.gov.gchq.koryphe.tuple.predicate.TupleAdaptedPredicate;

@JsonPropertyOrder(value={"preAggregationFilterFunctions", "groupBy", "aggregator", "postAggregationFilterFunctions", "transientProperties", "transformFunctions", "postTransformFilterFunctions", "properties", "excludeProperties"}, alphabetic=true)
@JsonDeserialize(builder=Builder.class)
public class ViewElementDefinition
implements ElementDefinition {
    protected ElementFilter preAggregationFilter;
    protected ElementFilter postAggregationFilter;
    protected ElementAggregator aggregator;
    protected ElementFilter postTransformFilter;
    protected ElementTransformer transformer;
    protected Set<String> groupBy;
    protected Set<String> properties;
    protected Set<String> excludeProperties;
    protected Map<String, Class<?>> transientProperties = new LinkedHashMap();

    @JsonIgnore
    public boolean isEmpty() {
        return null == this.preAggregationFilter && null == this.postAggregationFilter && null == this.aggregator && null == this.transformer && null == this.postTransformFilter && null == this.groupBy && null == this.properties && null == this.excludeProperties && null == this.transientProperties;
    }

    public Set<String> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(LinkedHashSet<String> groupBy) {
        this.groupBy = groupBy;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    @JsonIgnore
    public boolean isAllProperties() {
        return null == this.properties && (null == this.excludeProperties || this.excludeProperties.isEmpty());
    }

    public boolean hasProperty(String property) {
        return this.properties.contains(property);
    }

    public Class<?> getTransientPropertyClass(String propertyName) {
        return this.transientProperties.get(propertyName);
    }

    @JsonIgnore
    public Collection<Class<?>> getTransientPropertyClasses() {
        return this.transientProperties.values();
    }

    @JsonIgnore
    public Set<String> getTransientProperties() {
        return this.transientProperties.keySet();
    }

    public boolean containsTransientProperty(String propertyName) {
        return this.transientProperties.containsKey(propertyName);
    }

    @JsonIgnore
    public Map<String, Class<?>> getTransientPropertyMap() {
        return this.transientProperties;
    }

    @JsonGetter(value="transientProperties")
    public Map<String, String> getTransientPropertyMapWithClassNames() {
        if (this.transientProperties.isEmpty()) {
            return null;
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry<String, Class<?>> entry : this.transientProperties.entrySet()) {
            propertyMap.put(entry.getKey(), SimpleClassNameIdResolver.getSimpleClassName(entry.getValue()));
        }
        return propertyMap;
    }

    @JsonIgnore
    public ElementFilter getPreAggregationFilter() {
        return this.preAggregationFilter;
    }

    public List<TupleAdaptedPredicate<String, ?>> getPreAggregationFilterFunctions() {
        return null != this.preAggregationFilter ? this.preAggregationFilter.getComponents() : null;
    }

    public boolean hasPreAggregationFilters() {
        return null != this.preAggregationFilter && !this.preAggregationFilter.getComponents().isEmpty();
    }

    public ElementAggregator getAggregator() {
        return this.aggregator;
    }

    @Deprecated
    public void setAggregator(ElementAggregator aggregator) {
        this.aggregator = aggregator;
    }

    @JsonIgnore
    public ElementFilter getPostAggregationFilter() {
        return this.postAggregationFilter;
    }

    public List<TupleAdaptedPredicate<String, ?>> getPostAggregationFilterFunctions() {
        return null != this.postAggregationFilter ? this.postAggregationFilter.getComponents() : null;
    }

    public boolean hasPostAggregationFilters() {
        return null != this.postAggregationFilter && !this.postAggregationFilter.getComponents().isEmpty();
    }

    @JsonIgnore
    public ElementFilter getPostTransformFilter() {
        return this.postTransformFilter;
    }

    public List<TupleAdaptedPredicate<String, ?>> getPostTransformFilterFunctions() {
        return null != this.postTransformFilter ? this.postTransformFilter.getComponents() : null;
    }

    public boolean hasPostTransformFilters() {
        return null != this.postTransformFilter && !this.postTransformFilter.getComponents().isEmpty();
    }

    @JsonIgnore
    public ElementTransformer getTransformer() {
        return this.transformer;
    }

    public List<TupleAdaptedFunction<String, ?, ?>> getTransformFunctions() {
        return null != this.transformer ? this.transformer.getComponents() : null;
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Only inherits from Object")
    public ViewElementDefinition clone() {
        return ((Builder)new Builder().json(this.toJson(false, new String[0]))).build();
    }

    public byte[] toJson(boolean prettyPrint, String ... fieldsToExclude) throws SchemaException {
        try {
            return JSONSerialiser.serialise((Object)this, (boolean)prettyPrint, (String[])fieldsToExclude);
        }
        catch (SerialisationException e) {
            throw new SchemaException(e.getMessage(), e);
        }
    }

    public byte[] toCompactJson() throws SchemaException {
        return this.toJson(false, new String[0]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ViewElementDefinition that = (ViewElementDefinition)obj;
        return new EqualsBuilder().append((Object)this.transformer, (Object)that.transformer).append((Object)this.preAggregationFilter, (Object)that.preAggregationFilter).append((Object)this.postAggregationFilter, (Object)that.postAggregationFilter).append((Object)this.postTransformFilter, (Object)that.postTransformFilter).append(this.groupBy, that.groupBy).append(this.transientProperties, that.transientProperties).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 23).append((Object)this.transformer).append((Object)this.preAggregationFilter).append((Object)this.postAggregationFilter).append((Object)this.postTransformFilter).append(this.groupBy).append(this.transientProperties).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("transformer", (Object)this.transformer).append("preAggregationFilter", (Object)this.preAggregationFilter).append("postAggregationFilter", (Object)this.postAggregationFilter).append("postTransformFilter", (Object)this.postTransformFilter).append("groupBy", this.groupBy).append("transientProperties", this.transientProperties).toString();
    }

    @Override
    public void lock() {
        if (null != this.groupBy) {
            this.groupBy = Collections.unmodifiableSet(this.groupBy);
        }
        this.transientProperties = Collections.unmodifiableMap(this.transientProperties);
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder
    extends BaseBuilder<Builder> {
        public Builder() {
        }

        public Builder(ViewElementDefinition viewElementDef) {
            this();
            this.merge(viewElementDef);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class BaseBuilder<CHILD_CLASS extends BaseBuilder<?>> {
        private final ViewElementDefinition elDef;

        public BaseBuilder() {
            this.elDef = new ViewElementDefinition();
        }

        protected BaseBuilder(ViewElementDefinition elementDef) {
            this.elDef = elementDef;
        }

        public CHILD_CLASS allProperties() {
            this.elDef.properties = null;
            this.elDef.excludeProperties = null;
            return this.self();
        }

        @JsonSetter(value="properties")
        public CHILD_CLASS properties(Set<String> properties) {
            if (null != properties && null != this.elDef.excludeProperties && !this.elDef.excludeProperties.isEmpty()) {
                throw new IllegalArgumentException("You cannot set both properties and excludeProperties");
            }
            this.elDef.properties = properties;
            return this.self();
        }

        @JsonIgnore
        public CHILD_CLASS properties(String ... properties) {
            if (null != properties && null != this.elDef.excludeProperties && !this.elDef.excludeProperties.isEmpty()) {
                throw new IllegalArgumentException("You cannot set both properties and excludeProperties");
            }
            this.elDef.properties = null == properties ? null : Sets.newHashSet((Object[])properties);
            return this.self();
        }

        @JsonSetter(value="excludeProperties")
        public CHILD_CLASS excludeProperties(Set<String> excludeProperties) {
            if (null != excludeProperties && !excludeProperties.isEmpty() && null != this.elDef.properties) {
                throw new IllegalArgumentException("You cannot set both properties and excludeProperties");
            }
            this.elDef.excludeProperties = excludeProperties;
            return this.self();
        }

        @JsonIgnore
        public CHILD_CLASS excludeProperties(String ... excludeProperties) {
            if (null != excludeProperties && excludeProperties.length > 0 && null != this.elDef.properties) {
                throw new IllegalArgumentException("You cannot set both properties and excludeProperties");
            }
            this.elDef.excludeProperties = null == excludeProperties ? null : Sets.newHashSet((Object[])excludeProperties);
            return this.self();
        }

        public CHILD_CLASS transientProperty(String propertyName, Class<?> clazz) {
            this.elDef.transientProperties.put(propertyName, clazz);
            return this.self();
        }

        public CHILD_CLASS transientProperties(Map<String, Class<?>> transientProperties) {
            this.elDef.transientProperties = null == transientProperties ? new LinkedHashMap() : new LinkedHashMap(transientProperties);
            return this.self();
        }

        public CHILD_CLASS preAggregationFilter(ElementFilter preAggregationFilter) {
            if (null != this.getElementDef().getPreAggregationFilter()) {
                throw new IllegalArgumentException("ViewElementDefinition.Builder().preAggregationFilter(ElementFilter)may only be called once.");
            }
            this.getElementDef().preAggregationFilter = preAggregationFilter;
            return this.self();
        }

        public CHILD_CLASS clearPreAggregationFilter() {
            this.getElementDef().preAggregationFilter = null;
            return this.self();
        }

        public CHILD_CLASS preAggregationFilterFunctions(List<TupleAdaptedPredicate<String, ?>> filterFunctions) {
            this.getElementDef().preAggregationFilter = new ElementFilter();
            if (null != filterFunctions) {
                this.getElementDef().preAggregationFilter.getComponents().addAll(filterFunctions);
            }
            return this.self();
        }

        public CHILD_CLASS aggregator(ElementAggregator aggregator) {
            this.getElementDef().aggregator = aggregator;
            return this.self();
        }

        public CHILD_CLASS clearAggregator() {
            this.getElementDef().aggregator = null;
            return this.self();
        }

        public CHILD_CLASS postAggregationFilter(ElementFilter postAggregationFilter) {
            if (null != this.getElementDef().getPostAggregationFilter()) {
                throw new IllegalArgumentException("ViewElementDefinition.Builder().postAggregationFilter(ElementFilter)may only be called once.");
            }
            this.getElementDef().postAggregationFilter = postAggregationFilter;
            return this.self();
        }

        public CHILD_CLASS clearPostAggregationFilter() {
            this.getElementDef().postAggregationFilter = null;
            return this.self();
        }

        public CHILD_CLASS postAggregationFilterFunctions(List<TupleAdaptedPredicate<String, ?>> filterFunctions) {
            this.getElementDef().postAggregationFilter = new ElementFilter();
            if (null != filterFunctions) {
                this.getElementDef().postAggregationFilter.getComponents().addAll(filterFunctions);
            }
            return this.self();
        }

        public CHILD_CLASS postTransformFilter(ElementFilter postTransformFilter) {
            if (null != this.getElementDef().getPostTransformFilter()) {
                throw new IllegalArgumentException("ViewElementDefinition.Builder().postTransformFilter(ElementFilter)may only be called once.");
            }
            this.getElementDef().postTransformFilter = postTransformFilter;
            return this.self();
        }

        public CHILD_CLASS clearPostTransformFilter() {
            this.getElementDef().postTransformFilter = null;
            return this.self();
        }

        public CHILD_CLASS postTransformFilterFunctions(List<TupleAdaptedPredicate<String, ?>> filterFunctions) {
            this.getElementDef().postTransformFilter = new ElementFilter();
            if (null != filterFunctions) {
                this.getElementDef().postTransformFilter.getComponents().addAll(filterFunctions);
            }
            return this.self();
        }

        public CHILD_CLASS transformer(ElementTransformer transformer) {
            this.getElementDef().transformer = transformer;
            return this.self();
        }

        public CHILD_CLASS transformFunctions(List<TupleAdaptedFunction<String, ?, ?>> transformFunctions) {
            this.getElementDef().transformer = new ElementTransformer();
            return this.addTransformFunctions(transformFunctions);
        }

        public CHILD_CLASS addTransformFunctions(List<TupleAdaptedFunction<String, ?, ?>> transformFunctions) {
            if (null == this.getElementDef().transformer) {
                this.getElementDef().transformer = new ElementTransformer();
            }
            if (null != transformFunctions) {
                this.getElementDef().transformer.getComponents().addAll(transformFunctions);
            }
            return this.self();
        }

        public CHILD_CLASS clearTransform() {
            this.getElementDef().transformer = null;
            return this.self();
        }

        public CHILD_CLASS clearFunctions() {
            this.clearPreAggregationFilter();
            this.clearAggregator();
            this.clearPostAggregationFilter();
            this.clearTransform();
            this.clearPostTransformFilter();
            return this.self();
        }

        public CHILD_CLASS groupBy(String ... groupBy) {
            if (null != groupBy) {
                if (null == this.getElementDef().getGroupBy()) {
                    this.getElementDef().setGroupBy(new LinkedHashSet<String>());
                }
                Collections.addAll(this.getElementDef().getGroupBy(), groupBy);
            } else {
                this.getElementDef().setGroupBy(null);
            }
            return this.self();
        }

        @JsonIgnore
        public CHILD_CLASS json(byte[] jsonBytes) throws SchemaException {
            return this.json(jsonBytes, ViewElementDefinition.class);
        }

        @JsonIgnore
        protected CHILD_CLASS json(byte[] jsonBytes, Class<? extends ViewElementDefinition> clazz) throws SchemaException {
            if (null != jsonBytes) {
                try {
                    this.merge((ViewElementDefinition)JSONSerialiser.deserialise((byte[])jsonBytes, clazz));
                }
                catch (SerialisationException e) {
                    throw new SchemaException("Unable to deserialise json", e);
                }
            }
            return this.self();
        }

        public CHILD_CLASS merge(ViewElementDefinition elementDef) {
            if (null != elementDef) {
                for (Map.Entry<String, Class<?>> entry : elementDef.getTransientPropertyMap().entrySet()) {
                    String newProp = entry.getKey();
                    Class<?> newPropClass = entry.getValue();
                    if (!this.getElementDef().transientProperties.containsKey(newProp)) {
                        this.getElementDef().transientProperties.put(newProp, newPropClass);
                        continue;
                    }
                    Class<?> clazz = this.getElementDef().transientProperties.get(newProp);
                    if (clazz.equals(newPropClass)) continue;
                    throw new SchemaException("Unable to merge schemas. Conflict of transient property classes for " + newProp + ". Classes are: " + clazz.getName() + " and " + newPropClass.getName());
                }
                if (null == this.getElementDef().preAggregationFilter) {
                    this.getElementDef().preAggregationFilter = elementDef.preAggregationFilter;
                } else if (null != elementDef.preAggregationFilter) {
                    this.getElementDef().preAggregationFilter.getComponents().addAll(elementDef.preAggregationFilter.getComponents());
                }
                if (null == this.getElementDef().postAggregationFilter) {
                    this.getElementDef().postAggregationFilter = elementDef.postAggregationFilter;
                } else if (null != elementDef.postAggregationFilter) {
                    this.getElementDef().postAggregationFilter.getComponents().addAll(elementDef.postAggregationFilter.getComponents());
                }
                if (null == this.getElementDef().postTransformFilter) {
                    this.getElementDef().postTransformFilter = elementDef.postTransformFilter;
                } else if (null != elementDef.postTransformFilter) {
                    this.getElementDef().postTransformFilter.getComponents().addAll(elementDef.postTransformFilter.getComponents());
                }
                if (null == this.getElementDef().transformer) {
                    this.getElementDef().transformer = elementDef.transformer;
                } else if (null != elementDef.transformer) {
                    this.getElementDef().transformer.getComponents().addAll(elementDef.transformer.getComponents());
                }
                if (null != elementDef.getGroupBy()) {
                    this.getElementDef().groupBy = new LinkedHashSet<String>(elementDef.getGroupBy());
                }
                if (null != elementDef.getProperties()) {
                    this.properties(elementDef.getProperties());
                }
                if (null != elementDef.getExcludeProperties() && !elementDef.getExcludeProperties().isEmpty()) {
                    this.excludeProperties(elementDef.getExcludeProperties());
                }
            }
            return this.self();
        }

        public ViewElementDefinition build() {
            this.elDef.lock();
            return this.elDef;
        }

        public ViewElementDefinition getElementDef() {
            return this.elDef;
        }

        protected abstract CHILD_CLASS self();
    }
}

