/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.elementdefinition.view;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;

@JsonDeserialize(builder=Builder.class)
public class ViewParameterDetail
implements Serializable {
    private static final long serialVersionUID = -2732125973172603774L;
    private String description;
    private Object defaultValue;
    private Class valueClass;
    private boolean required;

    public ViewParameterDetail(String description, Class clazz, boolean required, Object defaultValue) {
        if (null == description) {
            throw new IllegalArgumentException("description must not be empty");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("class must not be empty");
        }
        if (required && null != defaultValue) {
            throw new IllegalArgumentException("required is true but a default value has been provided");
        }
        this.description = description;
        this.required = required;
        this.defaultValue = defaultValue;
        this.valueClass = clazz;
        try {
            byte[] json = JSONSerialiser.serialise((Object)defaultValue, (String[])new String[0]);
            JSONSerialiser.deserialise((byte[])json, (Class)this.valueClass);
        }
        catch (SerialisationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ViewParameterDetail vpd = (ViewParameterDetail)obj;
        return new EqualsBuilder().append(this.defaultValue, vpd.defaultValue).append(this.required, vpd.required).append((Object)this.description, (Object)vpd.description).append((Object)this.valueClass, (Object)vpd.valueClass).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(71, 5).append(this.defaultValue).append(this.required).append((Object)this.description).append((Object)this.valueClass).hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("description", (Object)this.description).append("valueClass", (Object)this.valueClass).append("required", this.required).append("defaultValue", this.defaultValue).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String description;
        private Object defaultValue;
        private boolean required = false;
        private Class valueClass;

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder valueClass(Class clazz) {
            this.valueClass = clazz;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public ViewParameterDetail build() {
            return new ViewParameterDetail(this.description, this.valueClass, this.required, this.defaultValue);
        }
    }
}

