/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.elementdefinition.view;

import java.util.LinkedHashMap;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.Properties;
import uk.gov.gchq.gaffer.data.elementdefinition.view.View;
import uk.gov.gchq.gaffer.data.elementdefinition.view.ViewElementDefinition;

public final class ViewUtil {
    private ViewUtil() {
    }

    public static void removeProperties(View view, Element element) {
        if (null != view && null != element) {
            ViewUtil.removeProperties(view.getElement(element.getGroup()), element);
        }
    }

    public static void removeProperties(ViewElementDefinition elDef, Element element) {
        ViewUtil.removeProperties(elDef, element.getProperties());
    }

    public static void removeProperties(ViewElementDefinition elDef, Properties properties) {
        if (null != elDef && !elDef.isAllProperties()) {
            if (null == elDef.getProperties()) {
                elDef.getExcludeProperties().forEach(properties::remove);
            } else {
                properties.keepOnly(elDef.getProperties());
            }
        }
    }

    public static View removeGroups(View view, String ... groups) {
        if (null == view) {
            throw new IllegalArgumentException("View cannot be null");
        }
        LinkedHashMap entities = new LinkedHashMap(view.getEntities());
        LinkedHashMap edges = new LinkedHashMap(view.getEdges());
        if (null != groups) {
            for (String group : groups) {
                entities.remove(group);
                edges.remove(group);
            }
        } else {
            throw new IllegalArgumentException("Specified group(s) to remove is null");
        }
        return ((View.Builder)((View.Builder)((View.Builder)new View.Builder().merge(view)).entities(entities)).edges(edges)).build();
    }
}

