/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.generator.OneToOneObjectGenerator;
import uk.gov.gchq.koryphe.Since;
import uk.gov.gchq.koryphe.Summary;

@Since(value="1.0.0")
@Summary(value="Generates a CSV string for each element")
public class CsvGenerator
implements OneToOneObjectGenerator<String> {
    public static final String GROUP = "GROUP";
    public static final String COMMA = ",";
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final String COMMA_REPLACEMENT_DEFAULT = " ";
    private LinkedHashMap<String, String> fields = new LinkedHashMap();
    private LinkedHashMap<String, String> constants = new LinkedHashMap();
    private boolean quoted = false;
    private String commaReplacement = " ";

    private Object getFieldValue(Element element, String key) {
        IdentifierType idType = IdentifierType.fromName(key);
        Object value = null == idType ? (GROUP.equals(key) ? element.getGroup() : element.getProperty(key)) : element.getIdentifier(idType);
        return value;
    }

    public LinkedHashMap<String, String> getFields() {
        return this.fields;
    }

    public void setFields(LinkedHashMap<String, String> fields) {
        if (null == fields) {
            this.fields = new LinkedHashMap();
        }
        this.fields = fields;
    }

    public LinkedHashMap<String, String> getConstants() {
        return this.constants;
    }

    public void setConstants(LinkedHashMap<String, String> constants) {
        if (null == constants) {
            this.constants = new LinkedHashMap();
        }
        this.constants = constants;
    }

    @Override
    public String _apply(Element element) {
        StringBuilder strBuilder = new StringBuilder();
        for (String field : this.fields.keySet()) {
            Object value = this.getFieldValue(element, field);
            if (null != value) {
                strBuilder.append(this.quoteString(value));
            }
            strBuilder.append(COMMA);
        }
        if (!this.constants.isEmpty()) {
            for (String constant : this.constants.keySet()) {
                strBuilder.append(this.quoteString(constant));
                strBuilder.append(COMMA);
            }
        }
        if (strBuilder.length() < 1) {
            return "";
        }
        return strBuilder.substring(0, strBuilder.length() - 1);
    }

    @JsonIgnore
    public String getHeader() {
        if (this.fields.isEmpty()) {
            if (this.constants.isEmpty()) {
                return "";
            }
            return this.getHeaderFields(this.constants.values());
        }
        if (this.constants.isEmpty()) {
            return this.getHeaderFields(this.fields.values());
        }
        return this.getHeaderFields(this.fields.values()) + COMMA + this.getHeaderFields(this.constants.values());
    }

    private String getHeaderFields(Collection<String> fields) {
        return StringUtils.join((Object[])fields.stream().map(this::quoteString).toArray(), (String)COMMA);
    }

    private String quoteString(Object s) {
        String value = null == s ? "" : s.toString();
        if (null != this.commaReplacement) {
            value = COMMA_PATTERN.matcher(value).replaceAll(this.commaReplacement);
        }
        if (this.quoted) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    public String getCommaReplacement() {
        return this.commaReplacement;
    }

    public void setCommaReplacement(String commaReplacement) {
        this.commaReplacement = commaReplacement;
    }

    public static class Builder {
        private LinkedHashMap<String, String> fields = new LinkedHashMap();
        private LinkedHashMap<String, String> constants = new LinkedHashMap();
        private String commaReplacement = " ";
        private Boolean quoted;

        public Builder group(String columnHeader) {
            this.fields.put(CsvGenerator.GROUP, columnHeader);
            return this;
        }

        public Builder property(String propertyName, String columnHeader) {
            this.fields.put(propertyName, columnHeader);
            return this;
        }

        public Builder vertex(String columnHeader) {
            return this.identifier(IdentifierType.VERTEX, columnHeader);
        }

        public Builder source(String columnHeader) {
            return this.identifier(IdentifierType.SOURCE, columnHeader);
        }

        public Builder destination(String columnHeader) {
            return this.identifier(IdentifierType.DESTINATION, columnHeader);
        }

        public Builder direction(String columnHeader) {
            return this.identifier(IdentifierType.DIRECTED, columnHeader);
        }

        public Builder identifier(IdentifierType identifierType, String columnHeader) {
            this.fields.put(identifierType.name(), columnHeader);
            return this;
        }

        public Builder constant(String key, String value) {
            this.constants.put(key, value);
            return this;
        }

        public Builder commaReplacement(String commaReplacement) {
            this.commaReplacement = commaReplacement;
            return this;
        }

        public Builder quoted(boolean quoted) {
            this.quoted = quoted;
            return this;
        }

        public CsvGenerator build() {
            CsvGenerator generator = new CsvGenerator();
            generator.setFields(this.fields);
            generator.setConstants(this.constants);
            generator.setCommaReplacement(this.commaReplacement);
            if (null != this.quoted) {
                generator.setQuoted(this.quoted);
            }
            return generator;
        }
    }
}

