/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.generator;

import java.util.LinkedHashMap;
import java.util.Map;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.generator.OneToOneObjectGenerator;
import uk.gov.gchq.koryphe.Since;
import uk.gov.gchq.koryphe.Summary;

@Since(value="1.0.0")
@Summary(value="Generates a Map for each element")
public class MapGenerator
implements OneToOneObjectGenerator<Map<String, Object>> {
    public static final String GROUP = "GROUP";
    private LinkedHashMap<String, String> fields = new LinkedHashMap();
    private LinkedHashMap<String, String> constants = new LinkedHashMap();

    @Override
    public Map<String, Object> _apply(Element element) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.fields.size() + this.constants.size());
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            Object value = this.getFieldValue(element, entry.getKey());
            if (null == value) continue;
            map.put(entry.getValue(), value);
        }
        map.putAll(this.constants);
        return map;
    }

    private Object getFieldValue(Element element, String key) {
        IdentifierType idType = IdentifierType.fromName(key);
        Object value = null == idType ? (GROUP.equals(key) ? element.getGroup() : element.getProperty(key)) : element.getIdentifier(idType);
        return value;
    }

    public LinkedHashMap<String, String> getFields() {
        return this.fields;
    }

    public void setFields(LinkedHashMap<String, String> fields) {
        if (null == fields) {
            this.fields = new LinkedHashMap();
        }
        this.fields = fields;
    }

    public LinkedHashMap<String, String> getConstants() {
        return this.constants;
    }

    public void setConstants(LinkedHashMap<String, String> constants) {
        if (null == constants) {
            this.constants = new LinkedHashMap();
        }
        this.constants = constants;
    }

    public static class Builder {
        private LinkedHashMap<String, String> fields = new LinkedHashMap();
        private LinkedHashMap<String, String> constants = new LinkedHashMap();

        public Builder group(String mapKey) {
            this.fields.put(MapGenerator.GROUP, mapKey);
            return this;
        }

        public Builder property(String propertyName, String mapKey) {
            this.fields.put(propertyName, mapKey);
            return this;
        }

        public Builder vertex(String mapKey) {
            return this.identifier(IdentifierType.VERTEX, mapKey);
        }

        public Builder source(String mapKey) {
            return this.identifier(IdentifierType.SOURCE, mapKey);
        }

        public Builder destination(String mapKey) {
            return this.identifier(IdentifierType.DESTINATION, mapKey);
        }

        public Builder direction(String mapKey) {
            return this.identifier(IdentifierType.DIRECTED, mapKey);
        }

        public Builder identifier(IdentifierType identifierType, String mapKey) {
            this.fields.put(identifierType.name(), mapKey);
            return this;
        }

        public Builder constant(String key, String value) {
            this.constants.put(key, value);
            return this;
        }

        public MapGenerator build() {
            MapGenerator generator = new MapGenerator();
            generator.setFields(this.fields);
            generator.setConstants(this.constants);
            return generator;
        }
    }
}

