/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.graph;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.gaffer.commonutil.CollectionUtil;
import uk.gov.gchq.gaffer.commonutil.stream.Streams;
import uk.gov.gchq.gaffer.data.element.Edge;
import uk.gov.gchq.gaffer.data.element.Entity;
import uk.gov.gchq.gaffer.data.element.id.EdgeId;
import uk.gov.gchq.gaffer.data.element.id.EntityId;

public class Walk
implements Iterable<Set<Edge>> {
    private final List<Set<Edge>> edges;
    private final List<Map.Entry<Object, Set<Entity>>> entities;

    private Walk(Builder builder) {
        this.entities = builder.entities;
        this.edges = builder.edges;
    }

    @JsonCreator
    public Walk(@JsonProperty(value="edges") List<Set<Edge>> edges, @JsonProperty(value="entities") List<Map.Entry<Object, Set<Entity>>> entities) {
        this.edges = edges;
        this.entities = entities;
    }

    @JsonIgnore
    public Set<Entity> getEntitiesForVertex(Object vertex) {
        return this.entities.stream().filter(e -> e.getKey().equals(vertex)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<Entity> getEntitiesAtDistance(int n) {
        return this.entities.get(n).getValue();
    }

    public List<Set<Edge>> getEdges() {
        return this.edges;
    }

    @JsonGetter(value="entities")
    public List<Map.Entry<Object, Set<Entity>>> getEntitiesAsEntries() {
        return this.entities;
    }

    @JsonIgnore
    public List<Set<Entity>> getEntities() {
        return this.entities.stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Object> getVerticesOrdered() {
        return this.entities.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @JsonIgnore
    public Set<Object> getVertexSet() {
        return this.entities.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @JsonIgnore
    public int length() {
        return this.edges.size();
    }

    @JsonIgnore
    public boolean isTrail() {
        return Sets.newHashSet(this.edges).size() == this.edges.size();
    }

    @JsonIgnore
    public boolean isPath() {
        return CollectionUtil.distinct(this.getVerticesOrdered());
    }

    @JsonIgnore
    public Object getSourceVertex() {
        return this.entities.get(0).getKey();
    }

    @JsonIgnore
    public Object getDestinationVertex() {
        return this.entities.get(this.entities.size() - 1).getKey();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        Walk walk = (Walk)obj;
        return new EqualsBuilder().append(this.edges, walk.edges).append(this.entities, walk.entities).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.edges).append(this.entities).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("edges", this.edges).append("entities", this.entities).toString();
    }

    @Override
    public Iterator<Set<Edge>> iterator() {
        return this.edges.iterator();
    }

    public static final class Builder {
        private final LinkedList<Set<Edge>> edges = new LinkedList();
        private final LinkedList<Map.Entry<Object, Set<Entity>>> entities = new LinkedList();

        public Builder edge(Edge edge) {
            if (this.entities.isEmpty()) {
                this.entities.add(new AbstractMap.SimpleEntry<Object, HashSet>(edge.getMatchedVertexValue(), Sets.newHashSet()));
            } else {
                this.verifyEdge(this.entities.getLast().getKey(), edge);
            }
            this.edges.add(Sets.newHashSet((Object[])new Edge[]{edge}));
            this.entities.add(new AbstractMap.SimpleEntry<Object, HashSet>(edge.getAdjacentMatchedVertexValue(), Sets.newHashSet()));
            return this;
        }

        public Builder edges(Edge ... edges) {
            if (!CollectionUtil.distinct((Collection)Streams.toStream((Object[])edges).map(EdgeId::getMatchedVertexValue).collect(Collectors.toList())) && !CollectionUtil.distinct((Collection)Streams.toStream((Object[])edges).map(EdgeId::getAdjacentMatchedVertexValue).collect(Collectors.toList()))) {
                this.edgeSet(Sets.newHashSet((Object[])edges));
            } else {
                this.edgeList(Arrays.asList(edges));
            }
            return this;
        }

        public Builder edges(Iterable<Edge> edges) {
            List<Edge> edgeList = Streams.toStream(edges).collect(Collectors.toList());
            if (!CollectionUtil.distinct((Collection)edgeList.stream().map(EdgeId::getMatchedVertexValue).collect(Collectors.toList())) && !CollectionUtil.distinct((Collection)edgeList.stream().map(EdgeId::getAdjacentMatchedVertexValue).collect(Collectors.toList()))) {
                this.edgeSet(Sets.newHashSet(edges));
            } else {
                this.edgeList(edgeList);
            }
            return this;
        }

        private Builder edgeSet(Set<Edge> edges) {
            Object matchedVertexValue = ((Edge)edges.stream().findFirst().orElseThrow(IllegalAccessError::new)).getMatchedVertexValue();
            Object adjacentMatchedVertexValue = ((Edge)edges.stream().findFirst().orElseThrow(IllegalAccessError::new)).getAdjacentMatchedVertexValue();
            if (this.entities.isEmpty()) {
                this.entities.add(new AbstractMap.SimpleEntry<Object, HashSet>(matchedVertexValue, Sets.newHashSet()));
            } else {
                Object root = this.entities.getLast().getKey();
                if (!Objects.equals(root, matchedVertexValue)) {
                    throw new IllegalArgumentException("Edge must continue the current walk.");
                }
            }
            this.edges.add(edges);
            this.entities.add(new AbstractMap.SimpleEntry<Object, HashSet>(adjacentMatchedVertexValue, Sets.newHashSet()));
            return this;
        }

        private Builder edgeList(List<Edge> edges) {
            edges.forEach(this::edge);
            return this;
        }

        public Builder entity(Entity entity) {
            Object root;
            if (!this.edges.isEmpty()) {
                root = ((Edge)this.edges.getLast().stream().findAny().orElseThrow(RuntimeException::new)).getAdjacentMatchedVertexValue();
                this.verifyEntity(root, entity);
            }
            if (!this.entities.isEmpty()) {
                root = this.entities.getLast().getKey();
                this.verifyEntity(root, entity);
                Map.Entry<Object, Set<Entity>> entry = this.entities.getLast();
                Set<Entity> currentEntities = entry.getValue();
                currentEntities.add(entity);
                entry.setValue(currentEntities);
            } else {
                this.entities.push(new AbstractMap.SimpleEntry<Object, HashSet>(entity.getVertex(), Sets.newHashSet((Object[])new Entity[]{entity})));
            }
            return this;
        }

        public Builder entities(Iterable<Entity> entities) {
            if (Iterables.isEmpty(entities)) {
                return this;
            }
            if (Iterables.size(entities) == 1) {
                return this.entity(entities.iterator().next());
            }
            if (CollectionUtil.distinct((Collection)Streams.toStream(entities).map(EntityId::getVertex).collect(Collectors.toList()))) {
                throw new IllegalArgumentException("Entities must all have the same vertex.");
            }
            Entity entity = entities.iterator().next();
            if (!this.edges.isEmpty()) {
                Object root = ((Edge)this.edges.getLast().stream().findAny().orElseThrow(RuntimeException::new)).getAdjacentMatchedVertexValue();
                this.verifyEntity(root, entity);
            }
            if (!this.entities.isEmpty()) {
                Map.Entry<Object, Set<Entity>> entry = this.entities.getLast();
                Object root = entry.getKey();
                this.verifyEntity(root, entity);
                Set<Entity> currentEntities = entry.getValue();
                currentEntities.addAll(Lists.newArrayList(entities));
                entry.setValue(currentEntities);
            } else {
                this.entities.push(new AbstractMap.SimpleEntry<Object, HashSet>(entity.getVertex(), Sets.newHashSet(entities)));
            }
            return this;
        }

        public Builder entities(Entity ... entities) {
            List<Entity> entityList = Arrays.asList(entities);
            if (1 == entityList.size()) {
                this.entity(entityList.get(0));
            } else {
                this.entities(entityList);
            }
            return this;
        }

        private void verifyEntity(Object source, Entity entity) {
            if (!Objects.equals(source, entity.getVertex())) {
                throw new IllegalArgumentException("Entity must be added to correct vertex.");
            }
        }

        private void verifyEdge(Object source, Edge edge) {
            if (!Objects.equals(source, edge.getMatchedVertexValue())) {
                throw new IllegalArgumentException("Edge must continue the current walk.");
            }
        }

        public Walk build() {
            return new Walk(this);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("edges", this.edges).append("entities", this.entities).toString();
        }
    }
}

