/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.graph.adjacency;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import uk.gov.gchq.gaffer.data.element.Edge;

public class AdjacencyMap {
    private final HashBasedTable<Object, Object, Set<Edge>> edgeGraph = HashBasedTable.create();

    public Set<Edge> getEdges(Object source, Object destination) {
        Set<Edge> results = (Set<Edge>)this.edgeGraph.get(source, destination);
        return null != results ? results : Collections.emptySet();
    }

    public Set<Edge> putEdges(Object source, Object destination, Set<Edge> set) {
        return set.stream().flatMap(v -> this.putEdge(source, destination, (Edge)v).stream()).collect(Collectors.toSet());
    }

    public Set<Edge> putEdge(Object source, Object destination, Edge edge) {
        Set existing = (Set)this.edgeGraph.get(source, destination);
        if (null == existing) {
            HashSet set = Sets.newHashSet((Object[])new Edge[]{edge});
            return (Set)this.edgeGraph.put(source, destination, (Object)set);
        }
        existing.add(edge);
        return existing;
    }

    public Set<Object> getDestinations(Object source) {
        return Collections.unmodifiableSet(this.edgeGraph.row(source).keySet());
    }

    public Set<Object> getSources(Object destination) {
        return Collections.unmodifiableSet(this.edgeGraph.column(destination).keySet());
    }

    public Set<Object> getAllSources() {
        return Collections.unmodifiableSet(this.edgeGraph.rowKeySet());
    }

    public Set<Object> getAllDestinations() {
        return Collections.unmodifiableSet(this.edgeGraph.columnKeySet());
    }

    public void removeAllWithDestination(Object destination) {
        HashSet set = Sets.newHashSet(this.getSources(destination));
        for (Object v : set) {
            this.edgeGraph.remove(v, destination);
        }
    }

    public boolean containsSource(Object source) {
        return this.edgeGraph.rowKeySet().contains(source);
    }

    public boolean containsDestination(Object destination) {
        return this.edgeGraph.columnKeySet().contains(destination);
    }

    public String toStringFull() {
        return super.toString() + '[' + this.toString() + ']';
    }

    public String toString() {
        return this.edgeGraph.rowKeySet().stream().map(s -> s.toString() + "->" + this.getDestinations(s)).collect(Collectors.joining(", ", "{", "}"));
    }
}

