/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.graph.adjacency;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import uk.gov.gchq.gaffer.data.graph.adjacency.AdjacencyMap;
import uk.gov.gchq.gaffer.data.graph.adjacency.AdjacencyMaps;

public class PrunedAdjacencyMaps
implements AdjacencyMaps {
    private final List<AdjacencyMap> adjacencyMaps = new ArrayList<AdjacencyMap>();

    @Override
    public void add(AdjacencyMap adjacencyMap) {
        this.removeOrphans(this.adjacencyMaps, adjacencyMap);
        this.adjacencyMaps.add(adjacencyMap);
    }

    private void removeOrphans(List<AdjacencyMap> maps, AdjacencyMap curr) {
        if (!maps.isEmpty()) {
            AdjacencyMap prev = maps.get(maps.size() - 1);
            Set<Object> prevDestinations = prev.getAllDestinations();
            ArrayList<Object> verticesToRemove = new ArrayList<Object>();
            for (Object dest : prevDestinations) {
                if (curr.containsSource(dest)) continue;
                verticesToRemove.add(dest);
            }
            for (Object dest : verticesToRemove) {
                prev.removeAllWithDestination(dest);
            }
            this.removeOrphans(maps.subList(0, maps.size() - 1), prev);
        }
    }

    @Override
    public List<AdjacencyMap> asList() {
        return this.adjacencyMaps;
    }
}

