/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.data.graph.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import uk.gov.gchq.gaffer.data.element.Entity;

public class EntityMap {
    private final SetMultimap<Object, Entity> backingMap = HashMultimap.create();

    public boolean putEntity(Object vertex, Entity entity) {
        return this.backingMap.put(vertex, (Object)entity);
    }

    public boolean putEntities(Object vertex, Set<Entity> entities) {
        return this.backingMap.putAll(vertex, entities);
    }

    public Set<Entity> get(Object vertex) {
        return this.backingMap.get(vertex);
    }

    public Set<Object> getVertices() {
        return Collections.unmodifiableSet(this.backingMap.keySet());
    }

    public boolean containsVertex(Object vertex) {
        return this.backingMap.containsKey(vertex);
    }

    public String toStringFull() {
        return super.toString() + '[' + this.toString() + ']';
    }

    public String toString() {
        return this.backingMap.asMap().entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }
}

