/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Client;
import uk.gov.gchq.gaffer.federated.rest.dto.Schema;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.gaffer.store.StoreTrait;

public class FederatedConfig {
    private Map<String, String> urlMap = new HashMap();
    private JSONSerialiser jsonSerialiser;
    private Map<String, Client> clients;
    private Set<StoreTrait> traits;
    private Set<String> filterFunctions;
    private Set<String> transformFunctions;
    private Set<String> generators;
    private Set<String> operations;
    private int connectTimeout = Integer.parseInt("60000");
    private int readTimeout = Integer.parseInt("60000");
    private Map<String, Schema> schemas;
    private Schema mergedSchema;
    private static FederatedConfig sharedConfig = new FederatedConfig();

    public static FederatedConfig getSharedConfig() {
        return sharedConfig;
    }

    public boolean isInitialised() {
        return null != this.mergedSchema;
    }

    public boolean hasUrls() {
        return !this.urlMap.isEmpty();
    }

    public int getNumUrls() {
        return this.urlMap.size();
    }

    public JSONSerialiser getJsonSerialiser() {
        return this.jsonSerialiser;
    }

    public void setJsonSerialiser(JSONSerialiser jsonSerialiser) {
        this.jsonSerialiser = jsonSerialiser;
    }

    public Map<String, String> getUrlMap() {
        return this.urlMap;
    }

    public Collection<String> getUrls() {
        return this.urlMap.values();
    }

    public void setUrlMap(Map<String, String> urls) {
        this.urlMap = urls;
    }

    public Map<String, Client> getClients() {
        return this.clients;
    }

    public void setClients(Map<String, Client> clients) {
        this.clients = clients;
    }

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Map<String, Schema> schemas) {
        this.schemas = schemas;
        this.mergedSchema = new Schema();
        for (Schema schema : schemas.values()) {
            this.mergedSchema.merge(schema);
        }
    }

    public Schema getMergedSchema() {
        return this.mergedSchema;
    }

    public Set<StoreTrait> getTraits() {
        return this.traits;
    }

    public void setTraits(Set<StoreTrait> traits) {
        this.traits = traits;
    }

    public Set<String> getOperations() {
        return this.operations;
    }

    public void setOperations(Set<String> operations) {
        this.operations = operations;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectTimeout(String connectTimeout) {
        this.connectTimeout = Integer.parseInt(connectTimeout);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setReadTimeout(String readTimeout) {
        this.readTimeout = Integer.parseInt(readTimeout);
    }

    public Set<String> getFilterFunctions() {
        return this.filterFunctions;
    }

    public void setFilterFunctions(Set<String> filterFunctions) {
        this.filterFunctions = filterFunctions;
    }

    public Set<String> getGenerators() {
        return this.generators;
    }

    public void setGenerators(Set<String> generators) {
        this.generators = generators;
    }

    public Set<String> getTransformFunctions() {
        return this.transformFunctions;
    }

    public void setTransformFunctions(Set<String> transformFunctions) {
        this.transformFunctions = transformFunctions;
    }
}

