/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.federated.rest.BlockingResultIterable;
import uk.gov.gchq.gaffer.federated.rest.FederatedConfig;
import uk.gov.gchq.gaffer.federated.rest.FederatedRequestor;
import uk.gov.gchq.gaffer.federated.rest.TypeReferenceFederatedImpl;
import uk.gov.gchq.gaffer.federated.rest.dto.FederatedSystemStatus;
import uk.gov.gchq.gaffer.federated.rest.dto.Operation;
import uk.gov.gchq.gaffer.federated.rest.dto.OperationChain;
import uk.gov.gchq.gaffer.federated.rest.dto.Schema;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.gaffer.operation.OperationException;
import uk.gov.gchq.gaffer.operation.impl.Validate;
import uk.gov.gchq.gaffer.operation.impl.add.AddElements;
import uk.gov.gchq.gaffer.operation.serialisation.TypeReferenceImpl;
import uk.gov.gchq.gaffer.store.StoreTrait;
import uk.gov.gchq.gaffer.store.TypeReferenceStoreImpl;
import uk.gov.gchq.gaffer.user.User;

public class FederatedExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FederatedExecutor.class);
    private final FederatedConfig config;
    private final FederatedRequestor requestor;

    public FederatedExecutor() {
        this(FederatedConfig.getSharedConfig(), new FederatedRequestor());
    }

    protected FederatedExecutor(FederatedConfig config, FederatedRequestor requestor) {
        this.config = config;
        this.requestor = requestor;
        requestor.initialise(config);
        if (null == config.getUrls() || !config.hasUrls()) {
            config.setUrlMap(this.loadUrls());
            config.setJsonSerialiser(this.createJsonSerialiser());
            config.setConnectTimeout(System.getProperty("gaffer.federated-rest.connect-timeout", "60000"));
            config.setReadTimeout(System.getProperty("gaffer.federated-rest.read-timeout", "60000"));
            config.setClients(this.createClients());
        }
    }

    public FederatedConfig getConfig() {
        if (!this.config.isInitialised()) {
            this.reinitialiseConfig();
        }
        return this.config;
    }

    public FederatedConfig reinitialiseConfig() {
        this.config.setClients(this.createClients());
        this.config.setTraits(this.fetchTraits());
        this.config.setOperations(this.fetchClasses("operations"));
        this.config.setFilterFunctions(this.fetchClasses("filterFunctions"));
        this.config.setTransformFunctions(this.fetchClasses("transformFunctions"));
        this.config.setGenerators(this.fetchClasses("generators"));
        this.config.setSchemas(this.fetchSchemaMaps());
        return this.config;
    }

    public Iterable<Object> executeOperation(Operation operation, Class opClass, User user, boolean skipErrors, boolean firstResult) {
        OperationChain opChain = new OperationChain();
        if (null != opClass) {
            operation.setClazz(opClass.getName());
        }
        opChain.setOperations(Collections.singletonList(operation));
        return this.executeOperationChain(opChain, user, skipErrors, false, firstResult);
    }

    public Iterable<Object> executeOperationChain(OperationChain operationChain, User user, boolean skipErrors, boolean runIndividually, boolean firstResult) {
        if (!this.config.hasUrls()) {
            throw new RuntimeException("No URLs specified to delegate operation chain to");
        }
        if (!this.config.isInitialised()) {
            this.reinitialiseConfig();
        }
        if (runIndividually && this.config.getNumUrls() > 1 && operationChain.getOperations().size() > 1) {
            Iterable previousResult = null;
            for (Operation operation : operationChain.getOperations()) {
                if (null != previousResult && null == operation.getInput()) {
                    operation.setInput(previousResult);
                }
                previousResult = this.executeOperationChain(new OperationChain(operation), user, skipErrors, false, firstResult);
            }
            return previousResult;
        }
        this.updateAddElementsOperations(operationChain);
        List results = Collections.synchronizedList(new ArrayList(this.config.getNumUrls()));
        for (Map.Entry entry : this.config.getUrlMap().entrySet()) {
            String name = (String)entry.getKey();
            String url = (String)entry.getValue();
            new Thread(() -> {
                try {
                    results.add(this.executeOperationChainViaUrl(operationChain.clone(), user, url, skipErrors));
                }
                catch (Exception e) {
                    String msg = "Failed to execute operations via: " + name + ". " + e.getMessage();
                    results.add(new OperationException(msg, (Throwable)e));
                    LOGGER.error(msg, (Throwable)e);
                }
            }).start();
        }
        return new BlockingResultIterable(results, this.config.getNumUrls(), (long)this.config.getConnectTimeout(), skipErrors, firstResult);
    }

    protected Iterable<Object> executeOperationChainViaUrl(OperationChain operationChain, User user, String url, boolean skipErrors) {
        boolean viewHasGroups = this.updateOperationViews(operationChain, url);
        Object resultObj = null;
        if (viewHasGroups) {
            resultObj = this.requestor.doPost(url, "graph/doOperation", (Object)operationChain, (TypeReference)new TypeReferenceImpl.Object(), user, skipErrors);
        }
        Iterable<Object> result = null == resultObj ? Collections.emptyList() : (resultObj instanceof Iterable ? (Iterable)resultObj : Collections.singletonList(resultObj));
        return result;
    }

    protected JSONSerialiser createJsonSerialiser() {
        return new JSONSerialiser();
    }

    protected Map<String, String> loadUrls() {
        LinkedHashMap<String, String> urls = new LinkedHashMap<String, String>();
        String urlCsv = System.getProperty("gaffer.federated-rest.urls", null);
        if (null != urlCsv) {
            String[] urlParts = urlCsv.split(",");
            int i = 0;
            while (i + 1 < urlParts.length) {
                urls.put(urlParts[i], urlParts[i + 1]);
                i += 2;
            }
        }
        return urls;
    }

    protected Map<String, Client> createClients() {
        HashMap<String, Client> clients = new HashMap<String, Client>(this.config.getNumUrls());
        for (String url : this.config.getUrls()) {
            Client client = ClientBuilder.newClient();
            client.property("jersey.config.client.connectTimeout", (Object)this.config.getConnectTimeout());
            client.property("jersey.config.client.readTimeout", (Object)this.config.getReadTimeout());
            clients.put(url, client);
        }
        return clients;
    }

    public List<FederatedSystemStatus> fetchSystemStatuses() {
        ArrayList<FederatedSystemStatus> results = new ArrayList<FederatedSystemStatus>();
        for (Map.Entry entry : this.config.getUrlMap().entrySet()) {
            String name = (String)entry.getKey();
            String url = (String)entry.getValue();
            FederatedSystemStatus status = (FederatedSystemStatus)this.requestor.doGet(url, "status", (TypeReference)new TypeReferenceFederatedImpl.SystemStatus(), null, true);
            if (null == status) {
                status = new FederatedSystemStatus();
                status.setDescription("No response");
                status.setStatus(404);
            }
            status.setUrl(url);
            status.setName(name);
            if (status.getDescription().contains("The system is working normally.")) {
                status.setStatus(200);
            } else if (status.getStatus() != 0) {
                status.setStatus(500);
            }
            LOGGER.info(status.toString());
            results.add(status);
        }
        return results;
    }

    protected Set<StoreTrait> fetchTraits() {
        HashSet proxyTraits = new HashSet();
        for (String url : this.config.getUrls()) {
            Set traits = (Set)this.requestor.doGet(url, "graph/storeTraits", (TypeReference)new TypeReferenceStoreImpl.StoreTraits(), null, true);
            if (null == traits) continue;
            proxyTraits.addAll(traits);
        }
        proxyTraits.remove(StoreTrait.VISIBILITY);
        return Collections.unmodifiableSet(proxyTraits);
    }

    protected Set<String> fetchClasses(String classType) {
        HashSet ops = new HashSet();
        for (String url : this.config.getUrls()) {
            Set classes = (Set)this.requestor.doGet(url, "graph/" + classType, (TypeReference)new TypeReferenceFederatedImpl.SetString(), null, true);
            if (null == classes) continue;
            ops.addAll(classes);
        }
        return Collections.unmodifiableSet(ops);
    }

    protected Map<String, Schema> fetchSchemaMaps() {
        HashMap<String, Schema> schemaMap = new HashMap<String, Schema>();
        for (String url : this.config.getUrls()) {
            Schema schemaPart = (Schema)this.requestor.doGet(url, "graph/schema", (TypeReference)new TypeReferenceFederatedImpl.Schema(), null, true);
            schemaMap.put(url, schemaPart);
        }
        return schemaMap;
    }

    protected void updateAddElementsOperations(OperationChain operationChain) {
        for (Operation operation : operationChain.getOperations()) {
            String opClass = operation.getClazz();
            if (!AddElements.class.getName().equals(opClass) && !Validate.class.getName().equals(opClass)) continue;
            operation.set("skipInvalidElements", "true");
        }
    }

    protected boolean updateOperationViews(OperationChain operationChain, String url) {
        boolean validView = true;
        for (Operation operation : operationChain.getOperations()) {
            if (null == operation.getView() || !operation.getView().hasGroups()) continue;
            operation.getView().removeInvalidGroups((Schema)this.config.getSchemas().get(url));
            validView = operation.getView().hasGroups();
        }
        return validView;
    }
}

