/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.federated.rest.FederatedConfig;
import uk.gov.gchq.gaffer.user.User;

public class FederatedRequestor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FederatedRequestor.class);
    private FederatedConfig config;

    public void initialise(FederatedConfig config) {
        this.config = config;
    }

    public <T> T doPost(String url, String urlSuffix, Object body, TypeReference<T> outputTypeReference, User user, boolean skipErrors) {
        return (T)this.doPost(url, urlSuffix, this.toJson(body), outputTypeReference, user, skipErrors);
    }

    public <T> T doPost(String url, String urlSuffix, String jsonBody, TypeReference<T> outputTypeReference, User user, boolean skipErrors) {
        try {
            return (T)this.handleResponse(this.executePost(url, urlSuffix, jsonBody, user), outputTypeReference, url);
        }
        catch (Exception e) {
            if (!skipErrors) {
                throw new RuntimeException(this.getErrorMsg(url, urlSuffix, e), e);
            }
            LOGGER.warn(this.getErrorMsg(url, urlSuffix, e), (Throwable)e);
            return null;
        }
    }

    public <T> T doGet(String url, String urlSuffix, TypeReference<T> outputTypeReference, User user, boolean skipErrors) {
        try {
            return (T)this.handleResponse(this.executeGet(url, urlSuffix, user), outputTypeReference, url);
        }
        catch (Exception e) {
            if (!skipErrors) {
                throw new RuntimeException(this.getErrorMsg(url, urlSuffix, e), e);
            }
            LOGGER.warn(this.getErrorMsg(url, urlSuffix, e), (Throwable)e);
            return null;
        }
    }

    protected Response executePost(String url, String urlSuffix, String jsonBody, User user) {
        Invocation.Builder request = this.createRequest(jsonBody, url, urlSuffix, user);
        return request.post(Entity.json((Object)jsonBody));
    }

    protected Response executeGet(String url, String urlSuffix, User user) {
        Invocation.Builder request = this.createRequest(null, url, urlSuffix, user);
        return request.get();
    }

    protected Invocation.Builder createRequest(String body, String url, String urlSuffix, User user) {
        Invocation.Builder request = ((Client)this.getConfig().getClients().get(url)).target(this.getFullUrl(url, urlSuffix)).request();
        if (null != body) {
            request.header("Content", (Object)MediaType.APPLICATION_JSON_TYPE);
            request.build(body);
        }
        return request;
    }

    protected <T> T handleResponse(Response response, TypeReference<T> outputTypeReference, String url) {
        String outputJson;
        String string = outputJson = response.hasEntity() ? (String)response.readEntity(String.class) : null;
        if (200 != response.getStatus() && 204 != response.getStatus()) {
            LOGGER.warn("Gaffer bad status " + response.getStatus());
            LOGGER.warn("Detail: " + outputJson);
            throw new RuntimeException("Error status from URL (" + url + "): " + response.getStatus() + ". Response content was: " + outputJson);
        }
        try {
            return (T)this.handleSuccessfulResponse(outputJson, outputTypeReference);
        }
        catch (SerialisationException e) {
            throw new RuntimeException("Unable to deserialise response from URL: " + url, e);
        }
    }

    protected <T> T handleSuccessfulResponse(String outputJson, TypeReference<T> outputTypeReference) throws SerialisationException {
        Object output = null;
        if (null != outputJson) {
            output = this.deserialise(outputJson, outputTypeReference);
        }
        return (T)output;
    }

    protected String getFullUrl(String url, String suffix) {
        String urlSuffix = StringUtils.isNotEmpty((String)suffix) ? this.prepend("/", suffix) : "";
        return url + urlSuffix;
    }

    protected <T> T deserialise(String jsonString, TypeReference<T> outputTypeReference) throws SerialisationException {
        byte[] jsonBytes;
        try {
            jsonBytes = jsonString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SerialisationException("Unable to deserialise JSON: " + jsonString, (Throwable)e);
        }
        return (T)this.getConfig().getJsonSerialiser().deserialise(jsonBytes, outputTypeReference);
    }

    protected String prepend(String prefix, String string) {
        if (!string.startsWith(prefix)) {
            return prefix + string;
        }
        return string;
    }

    protected FederatedConfig getConfig() {
        if (null == this.config) {
            throw new IllegalStateException("Config must be initialised prior to using this requestor");
        }
        return this.config;
    }

    protected String toJson(Object obj) {
        String json;
        try {
            json = new String(this.getConfig().getJsonSerialiser().serialise(obj, new String[0]), "UTF-8");
        }
        catch (UnsupportedEncodingException | SerialisationException e) {
            throw new IllegalArgumentException("Unable to serialise object into JSON: " + obj.toString(), e);
        }
        return json;
    }

    protected String getErrorMsg(String url, String urlSuffix, Exception e) {
        return this.getErrorMsg(this.getFullUrl(url, urlSuffix), e);
    }

    protected String getErrorMsg(String url, Exception e) {
        return this.getErrorMsg(url, e.getMessage());
    }

    protected String getErrorMsg(String url, String msg) {
        if (null != msg) {
            return "Error connecting to URL (" + url + ") " + msg;
        }
        return "Error connecting to URL (" + url + ")";
    }
}

