/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.application;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.jersey.server.ResourceConfig;
import uk.gov.gchq.gaffer.federated.rest.FederatedBinder;
import uk.gov.gchq.gaffer.federated.rest.service.FederatedGraphConfigurationService;
import uk.gov.gchq.gaffer.federated.rest.service.FederatedOperationService;
import uk.gov.gchq.gaffer.federated.rest.service.SystemStatusService;
import uk.gov.gchq.gaffer.rest.serialisation.RestJsonProvider;

public class FederatedApplicationConfig
extends ResourceConfig {
    protected final Set<Class<?>> resources = new HashSet();

    public FederatedApplicationConfig() {
        this.addSystemResources();
        this.addServices();
        this.setupBeanConfig();
        this.register((Object)new FederatedBinder());
        this.registerClasses(this.resources);
    }

    protected void setupBeanConfig() {
        BeanConfig beanConfig = new BeanConfig();
        String baseUrl = System.getProperty("gaffer.federated-rest.basePath", "rest/v1");
        if (!baseUrl.startsWith("/")) {
            baseUrl = "/" + baseUrl;
        }
        beanConfig.setBasePath(baseUrl);
        beanConfig.setVersion(System.getProperty("gaffer.federated-rest.version", "1.0.0"));
        beanConfig.setResourcePackage(System.getProperty("gaffer.federated-rest.resourcePackage", "uk.gov.gchq.gaffer.federated.rest"));
        beanConfig.setScan(true);
    }

    protected void addServices() {
        this.resources.add(SystemStatusService.class);
        this.resources.add(FederatedOperationService.class);
        this.resources.add(FederatedGraphConfigurationService.class);
    }

    protected void addSystemResources() {
        this.resources.add(ApiListingResource.class);
        this.resources.add(SwaggerSerializers.class);
        this.resources.add(RestJsonProvider.class);
    }
}

