/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.auth;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import uk.gov.gchq.gaffer.user.User;

/*
 * Exception performing whole class analysis ignored.
 */
public class FederatedConfigAuthoriser {
    public static final String AUTH_SEPARATOR = ",";
    private final Set<String> confAuths = new HashSet();

    public FederatedConfigAuthoriser() {
    }

    public FederatedConfigAuthoriser(Path propFileLocation) {
        this(FederatedConfigAuthoriser.readProperties((Path)propFileLocation));
    }

    public FederatedConfigAuthoriser(InputStream stream) {
        this(FederatedConfigAuthoriser.readProperties((InputStream)stream));
    }

    public FederatedConfigAuthoriser(Properties props) {
        this.loadOpAuthMap(props);
    }

    private static Properties readProperties(Path propFileLocation) {
        Properties props;
        if (null != propFileLocation) {
            try {
                props = FederatedConfigAuthoriser.readProperties((InputStream)Files.newInputStream(propFileLocation, StandardOpenOption.READ));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            props = new Properties();
        }
        return props;
    }

    private static Properties readProperties(InputStream stream) {
        Properties props = new Properties();
        if (null != stream) {
            try {
                props.load(stream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to load store properties file : " + e.getMessage(), e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return props;
    }

    public void setOpAuths(Set<String> auths) {
        this.confAuths.addAll(auths);
    }

    public void addConfAuths(String ... auths) {
        Collections.addAll(this.confAuths, auths);
    }

    public Set<String> getConfAuths() {
        return Collections.unmodifiableSet(this.confAuths);
    }

    public boolean authorise(User user) {
        Set userOpAuths = user.getOpAuths();
        boolean authorised = true;
        if (!userOpAuths.containsAll(this.confAuths)) {
            authorised = false;
        }
        return authorised;
    }

    private void loadOpAuthMap(Properties props) {
        HashSet<String> auths = new HashSet<String>();
        for (String auth : props.getProperty("gaffer.federated-rest.admin-auth").split(",")) {
            if (StringUtils.isEmpty((String)auth)) continue;
            auths.add(auth);
        }
        this.setOpAuths(auths);
    }
}

