/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import uk.gov.gchq.gaffer.federated.rest.util.CloneUtil;

public class Schema
implements Cloneable {
    private Map<String, Map> entities = new LinkedHashMap();
    private Map<String, Map> edges = new LinkedHashMap();
    private Map<String, Map> types = new LinkedHashMap();
    private Map<String, String> other = new LinkedHashMap();

    @JsonAnyGetter
    public Map<String, String> any() {
        return this.other;
    }

    @JsonAnySetter
    public void set(String name, String value) {
        this.other.put(name, value);
    }

    public Map<String, Map> getEntities() {
        return this.entities;
    }

    public void setEntities(Map<String, Map> entities) {
        this.entities = entities;
    }

    public Map<String, Map> getEdges() {
        return this.edges;
    }

    public void setEdges(Map<String, Map> edges) {
        this.edges = edges;
    }

    public Map<String, Map> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, Map> types) {
        this.types = types;
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="All fields are cloned")
    public Schema clone() {
        Schema schema = new Schema();
        schema.entities = (Map)CloneUtil.clone((Object)this.entities);
        schema.edges = (Map)CloneUtil.clone((Object)this.edges);
        schema.types = (Map)CloneUtil.clone((Object)this.types);
        schema.other = (Map)CloneUtil.clone((Object)this.other);
        return schema;
    }

    public void merge(Schema schema) {
        if (null != schema) {
            this.mergeMaps(this.entities, schema.entities);
            this.mergeMaps(this.edges, schema.edges);
            this.mergeMaps(this.types, schema.types);
            this.mergeMaps(this.other, schema.other);
        }
    }

    private void mergeMaps(Map map1, Map map2) {
        this.mergeMapObjects(map1, map2);
    }

    private void mergeMapObjects(Map<Object, Object> map1, Map<Object, Object> map2) {
        for (Map.Entry<Object, Object> entry : map2.entrySet()) {
            Object map1Value = map1.get(entry.getKey());
            Object map2Value = entry.getValue();
            if (null == map1Value) {
                map1.put(entry.getKey(), map2Value);
                continue;
            }
            if (null == map2Value) continue;
            if (map1Value instanceof Map && map2Value instanceof Map) {
                this.mergeMaps((Map)map1Value, (Map)map2Value);
                continue;
            }
            if (map1Value instanceof Object[] && map2Value instanceof Object[]) {
                LinkedHashSet mergedValue = new LinkedHashSet();
                Collections.addAll(mergedValue, (Object[])map1Value);
                Collections.addAll(mergedValue, (Object[])map2Value);
                map1.put(entry.getKey(), mergedValue.toArray(new Object[mergedValue.size()]));
                continue;
            }
            map1.put(entry.getKey(), map2Value);
        }
    }
}

