/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.gov.gchq.gaffer.federated.rest.dto.Schema;
import uk.gov.gchq.gaffer.federated.rest.util.CloneUtil;

public class View
implements Cloneable {
    private Map<String, Map> entities = new LinkedHashMap();
    private Map<String, Map> edges = new LinkedHashMap();
    private Map<String, String> other = new LinkedHashMap();

    @JsonAnyGetter
    public Map<String, String> any() {
        return this.other;
    }

    @JsonAnySetter
    public void set(String name, String value) {
        this.other.put(name, value);
    }

    public Map<String, Map> getEntities() {
        return this.entities;
    }

    public void setEntities(Map<String, Map> entities) {
        this.entities = entities;
    }

    public Map<String, Map> getEdges() {
        return this.edges;
    }

    public void setEdges(Map<String, Map> edges) {
        this.edges = edges;
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="All fields are cloned")
    public View clone() {
        View view = new View();
        view.entities = (Map)CloneUtil.clone((Object)this.entities);
        view.edges = (Map)CloneUtil.clone((Object)this.edges);
        view.other = (Map)CloneUtil.clone((Object)this.other);
        return view;
    }

    public void removeInvalidGroups(Schema schema) {
        if (this.hasGroups()) {
            HashSet invalidEntities = new HashSet(this.entities.keySet());
            HashSet invalidEdges = new HashSet(this.edges.keySet());
            invalidEntities.removeAll(schema.getEntities().keySet());
            invalidEdges.removeAll(schema.getEdges().keySet());
            for (String unknownEntity : invalidEntities) {
                this.entities.remove(unknownEntity);
            }
            for (String unknownEdge : invalidEdges) {
                this.edges.remove(unknownEdge);
            }
        }
    }

    public boolean hasGroups() {
        return !this.edges.isEmpty() || !this.entities.isEmpty();
    }
}

