/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.service;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.commonutil.exception.UnauthorisedException;
import uk.gov.gchq.gaffer.federated.rest.FederatedConfig;
import uk.gov.gchq.gaffer.federated.rest.FederatedExecutor;
import uk.gov.gchq.gaffer.federated.rest.auth.FederatedConfigAuthoriser;
import uk.gov.gchq.gaffer.federated.rest.dto.FederatedSystemStatus;
import uk.gov.gchq.gaffer.federated.rest.dto.GafferUrl;
import uk.gov.gchq.gaffer.federated.rest.dto.Schema;
import uk.gov.gchq.gaffer.federated.rest.service.FederatedOperationService;
import uk.gov.gchq.gaffer.federated.rest.service.IFederatedGraphConfigurationService;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.store.StoreTrait;
import uk.gov.gchq.gaffer.user.User;
import uk.gov.gchq.koryphe.signature.Signature;

public class FederatedGraphConfigurationService
implements IFederatedGraphConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FederatedOperationService.class);
    private final FederatedConfigAuthoriser authoriser = this.createAuthoriser();
    private final FederatedExecutor executor = this.createExecutor();
    @Inject
    private UserFactory userFactory;

    public GafferUrl addUrl(GafferUrl url) {
        if (null == url.getUrl() || url.getUrl().isEmpty()) {
            throw new IllegalArgumentException("URL is required");
        }
        if (null == url.getName() || url.getName().isEmpty()) {
            throw new IllegalArgumentException("URL name is required");
        }
        if (this.authoriser.authorise(this.createUser())) {
            FederatedConfig config = this.executor.getConfig();
            if (config.getUrlMap().containsKey(url.getName())) {
                throw new IllegalArgumentException("URL name is already in use: " + url.getName());
            }
            if (config.getUrlMap().containsValue(url.getUrl())) {
                throw new IllegalArgumentException("URL has already been registered: " + url);
            }
            LOGGER.info("Adding URL: " + url.getName() + ",  " + url.getUrl());
            config.getUrlMap().put(url.getName(), url.getUrl());
            this.refresh();
        }
        return url;
    }

    public List<FederatedSystemStatus> refresh() {
        this.executor.reinitialiseConfig();
        return this.executor.fetchSystemStatuses();
    }

    public boolean deleteUrl(String name) {
        boolean success;
        if (this.authoriser.authorise(this.createUser())) {
            String url = (String)this.executor.getConfig().getUrlMap().remove(name);
            boolean bl = success = null != url;
            if (success) {
                this.executor.reinitialiseConfig();
            }
        } else {
            throw new UnauthorisedException("");
        }
        return success;
    }

    public Set<GafferUrl> getUrls() {
        Map urlMap = this.executor.getConfig().getUrlMap();
        HashSet<GafferUrl> gafferUrls = new HashSet<GafferUrl>(urlMap.size());
        for (Map.Entry entry : urlMap.entrySet()) {
            gafferUrls.add(new GafferUrl((String)entry.getKey(), (String)entry.getValue()));
        }
        return gafferUrls;
    }

    public Schema getSchema() {
        return this.executor.getConfig().getMergedSchema();
    }

    public Set<String> getFilterFunctions() {
        return this.executor.getConfig().getFilterFunctions();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Need to wrap all runtime exceptions before they are given to the user")
    public Set<String> getFilterFunctions(String inputClass) {
        Class<?> clazz;
        if (StringUtils.isEmpty((String)inputClass)) {
            return this.executor.getConfig().getFilterFunctions();
        }
        try {
            clazz = Class.forName(inputClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input class was not recognised: " + inputClass, e);
        }
        HashSet<String> classes = new HashSet<String>();
        for (String functionClass : this.executor.getConfig().getFilterFunctions()) {
            try {
                Class<?> classInstance = Class.forName(functionClass);
                Predicate function = (Predicate)classInstance.newInstance();
                Signature signature = Signature.getInputSignature((Predicate)function);
                if (!signature.assignable(new Class[]{clazz}).isValid()) continue;
                classes.add(functionClass);
            }
            catch (Exception e) {
                classes.add(functionClass);
            }
        }
        return classes;
    }

    public Set<String> getTransformFunctions() {
        return this.executor.getConfig().getFilterFunctions();
    }

    public Set<String> getGenerators() {
        return this.executor.getConfig().getGenerators();
    }

    public Set<String> getOperations() {
        return this.executor.getConfig().getOperations();
    }

    public Set<StoreTrait> getStoreTraits() {
        return this.executor.getConfig().getTraits();
    }

    public Boolean isOperationSupported(String className) {
        return this.executor.getConfig().getOperations().contains(className);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Need to wrap all runtime exceptions before they are given to the user")
    public Set<String> getSerialisedFields(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class name was not recognised: " + className, e);
        }
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().constructType(clazz);
        BeanDescription introspection = mapper.getSerializationConfig().introspect(type);
        List properties = introspection.findProperties();
        HashSet<String> fields = new HashSet<String>();
        for (BeanPropertyDefinition property : properties) {
            fields.add(property.getName());
        }
        return fields;
    }

    protected User createUser() {
        return this.userFactory.createUser();
    }

    protected FederatedExecutor createExecutor() {
        return new FederatedExecutor();
    }

    protected FederatedConfigAuthoriser createAuthoriser() {
        return new FederatedConfigAuthoriser();
    }
}

