/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.server.ChunkedOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.federated.rest.FederatedExecutor;
import uk.gov.gchq.gaffer.federated.rest.dto.Operation;
import uk.gov.gchq.gaffer.federated.rest.dto.OperationChain;
import uk.gov.gchq.gaffer.federated.rest.service.IFederatedOperationService;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.gaffer.operation.impl.add.AddElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateObjects;
import uk.gov.gchq.gaffer.operation.impl.get.GetAdjacentIds;
import uk.gov.gchq.gaffer.operation.impl.get.GetAllElements;
import uk.gov.gchq.gaffer.operation.impl.get.GetElements;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.user.User;

public class FederatedOperationService
implements IFederatedOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FederatedOperationService.class);
    private final ObjectMapper mapper = JSONSerialiser.createDefaultMapper();
    private final FederatedExecutor executor = this.createExecutor();
    @Inject
    private UserFactory userFactory;

    public Iterable<Object> execute(OperationChain operationChain, boolean skipErrors, boolean runIndividually, boolean firstResult) {
        return this.executor.executeOperationChain(operationChain, this.createUser(), skipErrors, runIndividually, firstResult);
    }

    public Object execute(Operation operation, boolean skipErrors, boolean firstResult) {
        return this.executor.executeOperation(operation, Operation.class, this.createUser(), skipErrors, firstResult);
    }

    public ChunkedOutput<String> executeChunked(Operation operation, boolean skipErrors, boolean firstResult) {
        OperationChain opChain = new OperationChain();
        opChain.setOperations(Collections.singletonList(operation));
        return this.executeChunked(opChain, skipErrors, false, firstResult);
    }

    public ChunkedOutput<String> executeChunked(OperationChain opChain, boolean skipErrors, boolean runIndividually, boolean firstResult) {
        ChunkedOutput output = new ChunkedOutput(String.class, "\r\n");
        new Thread(() -> {
            try {
                Iterable result = this.execute(opChain, skipErrors, runIndividually, firstResult);
                this.chunkResult((Object)result, output);
            }
            finally {
                IOUtils.closeQuietly((Closeable)output);
            }
        }).start();
        return output;
    }

    public Iterable<Object> generateObjects(Operation operation, boolean skipErrors, boolean firstResult) {
        return this.executor.executeOperation(operation, GenerateObjects.class, this.createUser(), skipErrors, firstResult);
    }

    public Iterable<Object> generateElements(Operation operation, boolean skipErrors, boolean firstResult) {
        return this.executor.executeOperation(operation, GenerateElements.class, this.createUser(), skipErrors, firstResult);
    }

    public Iterable<Object> getAdjacentIds(Operation operation, boolean skipErrors, boolean firstResult) {
        return this.executor.executeOperation(operation, GetAdjacentIds.class, this.createUser(), skipErrors, firstResult);
    }

    public Iterable<Object> getAllElements(Operation operation, boolean skipErrors, boolean firstResult) {
        return this.executor.executeOperation(operation, GetAllElements.class, this.createUser(), skipErrors, firstResult);
    }

    public Iterable<Object> getElements(Operation operation, boolean skipErrors, boolean firstResult) {
        return this.executor.executeOperation(operation, GetElements.class, this.createUser(), skipErrors, firstResult);
    }

    public void addElements(Operation operation) {
        this.executor.executeOperation(operation, AddElements.class, this.createUser(), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chunkResult(Object result, ChunkedOutput<String> output) {
        if (result instanceof Iterable) {
            Iterable itr = (Iterable)result;
            try {
                for (Object item : itr) {
                    output.write((Object)this.mapper.writeValueAsString(item));
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("IOException (chunks)", (Throwable)ioe);
            }
            finally {
                if (itr instanceof Closeable) {
                    IOUtils.closeQuietly((Closeable)((Closeable)((Object)itr)));
                }
            }
        } else {
            try {
                output.write((Object)this.mapper.writeValueAsString(result));
            }
            catch (IOException ioe) {
                LOGGER.warn("IOException (chunks)", (Throwable)ioe);
            }
        }
    }

    protected FederatedExecutor createExecutor() {
        return new FederatedExecutor();
    }

    protected User createUser() {
        return this.userFactory.createUser();
    }
}

