/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import uk.gov.gchq.gaffer.federated.rest.dto.FederatedSystemStatus;
import uk.gov.gchq.gaffer.federated.rest.dto.GafferUrl;
import uk.gov.gchq.gaffer.store.StoreTrait;
import uk.gov.gchq.gaffer.store.schema.Schema;

@Path(value="/graph")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/graph", description="Methods to get graph configuration information.")
public interface IFederatedGraphConfigurationService {
    public static final String URLS_PATH = "urls";
    public static final String REFRESH_PATH = "urls/refresh";
    public static final String SCHEMA_PATH = "schema";
    public static final String FILTER_FUNCTIONS_PATH = "filterFunctions";
    public static final String TRANSFORM_FUNCTIONS_PATH = "transformFunctions";
    public static final String GENERATORS_PATH = "generators";
    public static final String OPERATIONS_PATH = "operations";
    public static final String STORE_TRAITS_PATH = "storeTraits";
    public static final String IS_OPERATION_SUPPORTED_PATH = "isOperationSupported";
    public static final String SERIALISED_FIELDS_PATH = "serialisedFields";

    @POST
    @Path(value="urls")
    @ApiOperation(value="Adds a new Gaffer URL to delegate operations to")
    public GafferUrl addUrl(GafferUrl var1);

    @DELETE
    @Path(value="urls/{name}")
    @ApiOperation(value="Deletes the url with the given name. Returns true if a url was deleted.", response=Boolean.class)
    public boolean deleteUrl(@ApiParam(value="The name of the url to delete") @PathParam(value="name") String var1);

    @GET
    @Path(value="urls")
    @ApiOperation(value="Gets the set of urls", response=GafferUrl.class, responseContainer="Set")
    public Set<GafferUrl> getUrls();

    @POST
    @Path(value="urls/refresh")
    @ApiOperation(value="Updates the cache containing the schemas fetched from the URLs", response=FederatedSystemStatus.class, responseContainer="List")
    public List<FederatedSystemStatus> refresh();

    @GET
    @Path(value="schema")
    @ApiOperation(value="Gets the schema", response=Schema.class)
    public uk.gov.gchq.gaffer.federated.rest.dto.Schema getSchema();

    @GET
    @Path(value="filterFunctions")
    @ApiOperation(value="Gets available filter functions. See <a href='https://github.com/gchq/Gaffer/wiki/filter-function-examples' target='_blank' style='text-decoration: underline;'>Wiki</a>.", response=Class.class, responseContainer="Set")
    public Set<String> getFilterFunctions();

    @GET
    @Path(value="filterFunctions/{inputClass}")
    @ApiOperation(value="Gets available filter functions for the given input class is provided.  See <a href='https://github.com/gchq/Gaffer/wiki/filter-function-examples' target='_blank' style='text-decoration: underline;'>Wiki</a>.", response=Class.class, responseContainer="Set")
    public Set<String> getFilterFunctions(@ApiParam(value="a function input java class") @PathParam(value="inputClass") String var1);

    @GET
    @Path(value="transformFunctions")
    @ApiOperation(value="Gets available transform functions", response=Class.class, responseContainer="Set")
    public Set<String> getTransformFunctions();

    @GET
    @Path(value="generators")
    @ApiOperation(value="Gets available generators", response=Class.class, responseContainer="Set")
    public Set<String> getGenerators();

    @GET
    @Path(value="operations")
    @ApiOperation(value="Gets all operations supported by the store. See <a href='https://github.com/gchq/Gaffer/wiki/operation-examples' target='_blank' style='text-decoration: underline;'>Wiki</a>.", response=Class.class, responseContainer="Set")
    public Set<String> getOperations();

    @GET
    @Path(value="storeTraits")
    @ApiOperation(value="Gets all supported store traits", response=StoreTrait.class, responseContainer="Set")
    public Set<StoreTrait> getStoreTraits();

    @POST
    @Path(value="isOperationSupported")
    @ApiOperation(value="Determines whether the operation type supplied is supported by the store", response=Boolean.class)
    public Boolean isOperationSupported(String var1);

    @GET
    @Path(value="serialisedFields/{className}")
    @ApiOperation(value="Gets all serialised fields for a given java class.", response=String.class, responseContainer="Set")
    public Set<String> getSerialisedFields(@ApiParam(value="a java class name") @PathParam(value="className") String var1);
}

