/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.federated.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.server.ChunkedOutput;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.federated.rest.dto.Operation;
import uk.gov.gchq.gaffer.federated.rest.dto.OperationChain;
import uk.gov.gchq.gaffer.operation.data.EntitySeed;

@Path(value="/graph/doOperation")
@Api(value="operations", description="Allows operations to be executed on the graph. See <a href='https://github.com/gchq/Gaffer/wiki/operation-examples' target='_blank'>Wiki</a>.")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface IFederatedOperationService {
    public static final String SKIP_ERRORS_MSG = "if true, then errors from delegate URLs will be skipped";
    public static final String FIRST_RESULT_MSG = "if true, the result will only contain the results from the first delegate URL to respond";
    public static final String RUN_INDIVIDUALLY_MSG = "if true, operations will be executed one at a time";
    public static final String SKIP_ERRORS_PARAM = "skipErrors";
    public static final String RUN_INDIVIDUALLY_PARAM = "runIndividually";
    public static final String FIRST_RESULT_PARAM = "firstResult";
    public static final String DO_OPERATION_PATH = "doOperation";

    @POST
    @ApiOperation(value="Performs the given operation chain on the graph", response=Object.class, responseContainer="List")
    public Iterable<Object> execute(OperationChain var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, operations will be executed one at a time") @QueryParam(value="runIndividually") boolean var3, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var4);

    @POST
    @Path(value="/operation")
    @ApiOperation(value="Performs the given operation on the graph", response=Object.class)
    public Object execute(Operation var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var3);

    @POST
    @Path(value="/chunked/operation")
    @ApiOperation(value="Performs the given operation on the graph, returned chunked output. NOTE - does not work in Swagger.", response=Object.class)
    public ChunkedOutput<String> executeChunked(Operation var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var3);

    @POST
    @Path(value="/chunked")
    @ApiOperation(value="Performs the given operation chain on the graph, returned chunked output. NOTE - does not work in Swagger.", response=Object.class, responseContainer="List")
    public ChunkedOutput<String> executeChunked(OperationChain var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, operations will be executed one at a time") @QueryParam(value="runIndividually") boolean var3, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var4);

    @POST
    @Path(value="/generate/objects")
    @ApiOperation(value="Generate objects from elements", response=Object.class, responseContainer="List")
    public Iterable<Object> generateObjects(Operation var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var3);

    @POST
    @Path(value="/generate/elements")
    @ApiOperation(value="Generate elements from objects", response=Element.class, responseContainer="List")
    public Iterable<Object> generateElements(Operation var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var3);

    @POST
    @Path(value="/get/entitySeeds/adjacent")
    @ApiOperation(value="Gets adjacent entity seeds", response=EntitySeed.class, responseContainer="List")
    public Iterable<Object> getAdjacentIds(Operation var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var3);

    @POST
    @Path(value="/get/elements/all")
    @ApiOperation(value="Gets all elements", response=Element.class, responseContainer="List")
    public Iterable<Object> getAllElements(Operation var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var3);

    @POST
    @Path(value="/get/elements")
    @ApiOperation(value="Gets elements", response=Element.class, responseContainer="List")
    public Iterable<Object> getElements(Operation var1, @ApiParam(value="if true, then errors from delegate URLs will be skipped") @QueryParam(value="skipErrors") boolean var2, @ApiParam(value="if true, the result will only contain the results from the first delegate URL to respond") @QueryParam(value="firstResult") boolean var3);

    @PUT
    @Path(value="/add/elements")
    @ApiOperation(value="Add elements to the graph")
    public void addElements(Operation var1);
}

