/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest;

import javax.inject.Singleton;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import uk.gov.gchq.gaffer.rest.SystemProperty;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;

public class FactoriesBinder
extends AbstractBinder {
    protected void configure() {
        this.bind(this.getDefaultGraphFactory()).to(GraphFactory.class).in(Singleton.class);
        this.bind(this.getDefaultUserFactory()).to(UserFactory.class).in(Singleton.class);
    }

    private Class<? extends GraphFactory> getDefaultGraphFactory() {
        String graphFactoryClass = System.getProperty("gaffer.graph.factory.class", SystemProperty.GRAPH_FACTORY_CLASS_DEFAULT);
        try {
            return Class.forName(graphFactoryClass).asSubclass(GraphFactory.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to create graph factory from class: " + graphFactoryClass, e);
        }
    }

    private Class<? extends UserFactory> getDefaultUserFactory() {
        String userFactoryClass = System.getProperty("gaffer.user.factory.class", SystemProperty.USER_FACTORY_CLASS_DEFAULT);
        try {
            return Class.forName(userFactoryClass).asSubclass(UserFactory.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to create user factory from class: " + userFactoryClass, e);
        }
    }
}

