/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest;

public final class ServiceConstants {
    public static final String GAFFER_MEDIA_TYPE_HEADER = "X-Gaffer-Media-Type";
    public static final String GAFFER_MEDIA_TYPE;
    public static final String GAFFER_MEDIA_TYPE_HEADER_DESCRIPTION = "The gaffer media type containing the REST API version.";
    public static final String JOB_ID_HEADER = "job-id";
    public static final String JOB_ID_HEADER_DESCRIPTION = "The job execution ID.";
    public static final String OK = "OK";
    public static final String BAD_REQUEST = "Error while processing request body";
    public static final String FORBIDDEN = "The current user cannot perform the requested operation";
    public static final String INTERNAL_SERVER_ERROR = "Something went wrong in the server";
    public static final String CLASS_NOT_FOUND = "Class not found";
    public static final String FUNCTION_NOT_FOUND = "Function not found";
    public static final String PROPERTY_NOT_FOUND = "Property not found";
    public static final String OPERATION_NOT_FOUND = "Operation not found";
    public static final String OPERATION_NOT_IMPLEMENTED = "The requested operation is not supported by the target store";
    public static final String JOB_CREATED = "A new job was successfully submitted";
    public static final String JOB_NOT_FOUND = "Job was not found";
    public static final String JOB_SERVICE_UNAVAILABLE = "The job service is not available";

    private ServiceConstants() {
    }

    static {
        String apiVersion = System.getProperty("gaffer.rest-api.version", "2.0.0");
        GAFFER_MEDIA_TYPE = "gaffer.v" + apiVersion.charAt(0) + "; format=json";
    }
}

