/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.factory;

import java.nio.file.Path;
import java.nio.file.Paths;
import uk.gov.gchq.gaffer.data.elementdefinition.exception.SchemaException;
import uk.gov.gchq.gaffer.graph.Graph;
import uk.gov.gchq.gaffer.rest.SystemProperty;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.store.StoreProperties;
import uk.gov.gchq.gaffer.store.library.GraphLibrary;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultGraphFactory
implements GraphFactory {
    private static Graph graph;
    private boolean singletonGraph = true;

    public static GraphFactory createGraphFactory() {
        String graphFactoryClass = System.getProperty("gaffer.graph.factory.class", SystemProperty.GRAPH_FACTORY_CLASS_DEFAULT);
        try {
            return Class.forName(graphFactoryClass).asSubclass(GraphFactory.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to create graph factory from class: " + graphFactoryClass, e);
        }
    }

    protected static Path[] getSchemaPaths() {
        String schemaPaths = System.getProperty("gaffer.schemas");
        if (null == schemaPaths) {
            return new Path[0];
        }
        String[] schemaPathsArray = schemaPaths.split(",");
        Path[] paths = new Path[schemaPathsArray.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = Paths.get(schemaPathsArray[i], new String[0]);
        }
        return paths;
    }

    public Graph getGraph() {
        if (this.singletonGraph) {
            if (null == graph) {
                DefaultGraphFactory.setGraph((Graph)this.createGraph());
            }
            return graph;
        }
        return this.createGraph();
    }

    public static void setGraph(Graph graph) {
        DefaultGraphFactory.graph = graph;
    }

    public boolean isSingletonGraph() {
        return this.singletonGraph;
    }

    public void setSingletonGraph(boolean singletonGraph) {
        this.singletonGraph = singletonGraph;
    }

    public Graph.Builder createGraphBuilder() {
        String graphHooksPath;
        String graphLibraryClassName;
        String storePropertiesPath = System.getProperty("gaffer.storeProperties");
        if (null == storePropertiesPath) {
            throw new SchemaException("The path to the Store Properties was not found in system properties for key: gaffer.storeProperties");
        }
        StoreProperties storeProperties = StoreProperties.loadStoreProperties((String)storePropertiesPath);
        storeProperties.addOperationDeclarationPaths(new String[]{"disableOperations.json"});
        Graph.Builder builder = new Graph.Builder();
        builder.storeProperties(storeProperties);
        String graphConfigPath = System.getProperty("gaffer.graph.config");
        if (null != graphConfigPath) {
            builder.config(Paths.get(graphConfigPath, new String[0]));
        }
        for (Path path : DefaultGraphFactory.getSchemaPaths()) {
            builder.addSchema(path);
        }
        String graphId = System.getProperty("gaffer.graph.id");
        if (null != graphId) {
            builder.graphId(graphId);
        }
        if (null != (graphLibraryClassName = System.getProperty("gaffer.graph.library.class"))) {
            GraphLibrary library;
            try {
                library = Class.forName(graphLibraryClassName).asSubclass(GraphLibrary.class).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error creating GraphLibrary class: + " + e);
            }
            library.initialise(System.getProperty("gaffer.graph.library.config"));
            builder.library(library);
        }
        if (null != (graphHooksPath = System.getProperty("gaffer.graph.hooks.path"))) {
            builder.addHooks(Paths.get(graphHooksPath, new String[0]));
        }
        return builder;
    }
}

