/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.factory;

import uk.gov.gchq.gaffer.graph.Graph;
import uk.gov.gchq.gaffer.rest.SystemProperty;

public interface GraphFactory {
    public static GraphFactory createGraphFactory() {
        String graphFactoryClass = System.getProperty("gaffer.graph.factory.class", SystemProperty.GRAPH_FACTORY_CLASS_DEFAULT);
        try {
            return Class.forName(graphFactoryClass).asSubclass(GraphFactory.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to create graph factory from class: " + graphFactoryClass, e);
        }
    }

    public Graph.Builder createGraphBuilder();

    default public Graph createGraph() {
        return this.createGraphBuilder().build();
    }

    public Graph getGraph();
}

