/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.factory;

import uk.gov.gchq.gaffer.rest.SystemProperty;
import uk.gov.gchq.gaffer.store.Context;
import uk.gov.gchq.gaffer.user.User;

public interface UserFactory {
    public static UserFactory createUserFactory() {
        String userFactoryClass = System.getProperty("gaffer.user.factory.class", SystemProperty.USER_FACTORY_CLASS_DEFAULT);
        try {
            return Class.forName(userFactoryClass).asSubclass(UserFactory.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to create user factory from class: " + userFactoryClass, e);
        }
    }

    public User createUser();

    default public Context createContext() {
        return new Context(this.createUser());
    }
}

