/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v1;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import uk.gov.gchq.gaffer.data.generator.ElementGenerator;
import uk.gov.gchq.gaffer.data.generator.ObjectGenerator;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.rest.service.v1.IGraphConfigurationService;
import uk.gov.gchq.gaffer.store.StoreTrait;
import uk.gov.gchq.gaffer.store.schema.Schema;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;
import uk.gov.gchq.koryphe.signature.Signature;
import uk.gov.gchq.koryphe.util.ReflectionUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GraphConfigurationService
implements IGraphConfigurationService {
    @Inject
    private GraphFactory graphFactory;
    @Inject
    private UserFactory userFactory;

    public GraphConfigurationService() {
        GraphConfigurationService.updateReflectionPaths();
    }

    public static void initialise() {
        GraphConfigurationService.updateReflectionPaths();
    }

    private static void updateReflectionPaths() {
        ReflectionUtil.addReflectionPackages((String[])new String[]{System.getProperty("gaffer.package.prefixes", "uk.gov.gchq")});
    }

    public Schema getSchema() {
        return this.graphFactory.getGraph().getSchema();
    }

    public String getDescription() {
        return this.graphFactory.getGraph().getDescription();
    }

    public Set<Class> getFilterFunctions() {
        return ReflectionUtil.getSubTypes(Predicate.class);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Need to wrap all runtime exceptions before they are given to the user")
    public Set<Class> getFilterFunctions(String inputClass) {
        Class<?> clazz;
        if (StringUtils.isEmpty((CharSequence)inputClass)) {
            return this.getFilterFunctions();
        }
        try {
            clazz = Class.forName(SimpleClassNameIdResolver.getClassName((String)inputClass));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input class was not recognised: " + inputClass, e);
        }
        HashSet<Class> classes = new HashSet<Class>();
        for (Class functionClass : ReflectionUtil.getSubTypes(Predicate.class)) {
            try {
                Predicate function = (Predicate)functionClass.newInstance();
                Signature signature = Signature.getInputSignature((Predicate)function);
                if (null != signature.getNumClasses() && (1 != signature.getNumClasses() || !Signature.UnknownGenericType.class.isAssignableFrom(signature.getClasses()[0]) && !signature.getClasses()[0].isAssignableFrom(clazz))) continue;
                classes.add(functionClass);
            }
            catch (Exception e) {
                classes.add(functionClass);
            }
        }
        return classes;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Need to wrap all runtime exceptions before they are given to the user")
    public Set<String> getSerialisedFields(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(SimpleClassNameIdResolver.getClassName((String)className));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class name was not recognised: " + className, e);
        }
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().constructType(clazz);
        BeanDescription introspection = mapper.getSerializationConfig().introspect(type);
        List properties = introspection.findProperties();
        HashSet<String> fields = new HashSet<String>();
        for (BeanPropertyDefinition property : properties) {
            fields.add(property.getName());
        }
        return fields;
    }

    public Set<Class> getTransformFunctions() {
        return ReflectionUtil.getSubTypes(Function.class);
    }

    public Set<StoreTrait> getStoreTraits() {
        return this.graphFactory.getGraph().getStoreTraits();
    }

    public Set<Class> getNextOperations(String operationClassName) {
        Class<Operation> opClass;
        try {
            opClass = Class.forName(SimpleClassNameIdResolver.getClassName((String)operationClassName)).asSubclass(Operation.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Operation class was not found: " + operationClassName, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(operationClassName + " does not extend Operation", e);
        }
        return this.graphFactory.getGraph().getNextOperations(opClass);
    }

    public Set<Class> getElementGenerators() {
        return ReflectionUtil.getSubTypes(ElementGenerator.class);
    }

    public Set<Class> getObjectGenerators() {
        return ReflectionUtil.getSubTypes(ObjectGenerator.class);
    }

    public Set<Class> getOperations() {
        return this.graphFactory.getGraph().getSupportedOperations();
    }

    public Boolean isOperationSupported(Class operation) {
        return this.graphFactory.getGraph().isSupported(operation);
    }
}

