/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.jersey.server.ChunkedOutput;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.id.EntityId;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChainDAO;
import uk.gov.gchq.gaffer.operation.impl.add.AddElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateObjects;
import uk.gov.gchq.gaffer.operation.impl.get.GetAdjacentIds;
import uk.gov.gchq.gaffer.operation.impl.get.GetAllElements;
import uk.gov.gchq.gaffer.operation.impl.get.GetElements;

@Path(value="/graph/doOperation")
@Api(value="operations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface IOperationService {
    @POST
    @ApiOperation(value="Performs the given operation chain on the graph", response=Object.class)
    public Object execute(OperationChainDAO var1);

    @POST
    @Path(value="/operation")
    @ApiOperation(value="Performs the given operation on the graph", response=Object.class)
    public Object execute(Operation var1);

    @POST
    @Path(value="/chunked/operation")
    @ApiOperation(value="Performs the given operation on the graph, returned chunked output. NOTE - does not work in Swagger.", response=Object.class)
    public ChunkedOutput<String> executeChunked(Operation var1);

    @POST
    @Path(value="/chunked")
    @ApiOperation(value="Performs the given operation chain on the graph, returned chunked output. NOTE - does not work in Swagger.", response=Object.class)
    public ChunkedOutput<String> executeChunkedChain(OperationChainDAO<CloseableIterable<Element>> var1);

    @POST
    @Path(value="/generate/objects")
    @ApiOperation(value="Generate objects from elements", response=Object.class, responseContainer="List")
    public CloseableIterable<Object> generateObjects(GenerateObjects<Object> var1);

    @POST
    @Path(value="/generate/elements")
    @ApiOperation(value="Generate elements from objects", response=Element.class, responseContainer="List")
    public CloseableIterable<Element> generateElements(GenerateElements<Object> var1);

    @POST
    @Path(value="/get/entityIds/adjacent")
    @ApiOperation(value="Gets adjacent entity seeds", response=EntityId.class, responseContainer="List")
    public CloseableIterable<EntityId> getAdjacentIds(GetAdjacentIds var1);

    @POST
    @Path(value="/get/elements/all")
    @ApiOperation(value="Gets all elements", response=Element.class, responseContainer="List")
    public CloseableIterable<Element> getAllElements(GetAllElements var1);

    @POST
    @Path(value="/get/elements")
    @ApiOperation(value="Gets elements", response=Element.class, responseContainer="List")
    public CloseableIterable<Element> getElements(GetElements var1);

    @PUT
    @Path(value="/add/elements")
    @ApiOperation(value="Add elements to the graph", response=Boolean.class)
    public void addElements(AddElements var1);
}

