/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v1;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.jobtracker.JobDetail;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChain;
import uk.gov.gchq.gaffer.operation.OperationChainDAO;
import uk.gov.gchq.gaffer.operation.OperationException;
import uk.gov.gchq.gaffer.operation.impl.job.GetAllJobDetails;
import uk.gov.gchq.gaffer.operation.impl.job.GetJobDetails;
import uk.gov.gchq.gaffer.operation.impl.job.GetJobResults;
import uk.gov.gchq.gaffer.operation.io.Output;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.rest.service.v1.IJobService;
import uk.gov.gchq.gaffer.store.Context;

public class JobService
implements IJobService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobService.class);
    @Inject
    private GraphFactory graphFactory;
    @Inject
    private UserFactory userFactory;

    public JobDetail executeJob(OperationChainDAO opChain) {
        Context context = this.userFactory.createContext();
        this.preOperationHook((OperationChain)opChain, context);
        try {
            JobDetail jobDetail = this.graphFactory.getGraph().executeJob((Operation)opChain, context);
            LOGGER.info("Job started = {}", (Object)jobDetail);
            JobDetail jobDetail2 = jobDetail;
            return jobDetail2;
        }
        catch (OperationException e) {
            throw new RuntimeException("Error executing opChain: " + e.getMessage(), e);
        }
        finally {
            this.postOperationHook((OperationChain)opChain, context);
        }
    }

    public CloseableIterable<JobDetail> details() {
        try {
            return (CloseableIterable)this.graphFactory.getGraph().execute((Output)new GetAllJobDetails(), this.userFactory.createContext());
        }
        catch (OperationException e) {
            throw new RuntimeException(e);
        }
    }

    public JobDetail details(String id) {
        try {
            return (JobDetail)this.graphFactory.getGraph().execute((Output)new GetJobDetails.Builder().jobId(id).build(), this.userFactory.createContext());
        }
        catch (OperationException e) {
            throw new RuntimeException(e);
        }
    }

    public CloseableIterable results(String id) {
        try {
            return (CloseableIterable)this.graphFactory.getGraph().execute((Output)((GetJobResults.Builder)new GetJobResults.Builder().jobId(id)).build(), this.userFactory.createContext());
        }
        catch (OperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void preOperationHook(OperationChain<?> opChain, Context context) {
    }

    protected void postOperationHook(OperationChain<?> opChain, Context context) {
    }
}

