/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import uk.gov.gchq.gaffer.jobtracker.Job;
import uk.gov.gchq.gaffer.jobtracker.JobDetail;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationException;

@Path(value="/graph/jobs")
@Api(value="job")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface IJobServiceV2 {
    @POST
    @ApiOperation(value="Submits the given operation job to the graph", notes="A Job essentially runs an OperationChain (OpChain) asynchronously, and caches the results. This endpoint submits a provided Operation or OpChain to the graph for execution, as a Job. This can be useful if an OpChain takes a long time to return results, or you'd like the results to be stored. One small difference is that a JobDetail is returned rather than the results directly, but they can be extracted with the GetJobResults Operation/Endpoint.", response=JobDetail.class, code=201, produces="application/json", responseHeaders={@ResponseHeader(name="job-id", description="The job execution ID."), @ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=201, message="A new job was successfully submitted"), @ApiResponse(code=400, message="Error while processing request body"), @ApiResponse(code=403, message="The current user cannot perform the requested operation"), @ApiResponse(code=500, message="Something went wrong in the server"), @ApiResponse(code=501, message="The requested operation is not supported by the target store"), @ApiResponse(code=503, message="The job service is not available")})
    public Response executeJob(@ApiParam(value="The operation job to be submitted to the graph") Operation var1) throws OperationException;

    @POST
    @Path(value="/schedule")
    @ApiOperation(value="Performs the given scheduled operation chain job on the graph", response=JobDetail.class, code=201, produces="application/json", responseHeaders={@ResponseHeader(name="job-id", description="The job execution ID."), @ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=201, message="A new job was successfully submitted"), @ApiResponse(code=400, message="Error while processing request body"), @ApiResponse(code=403, message="The current user cannot perform the requested operation"), @ApiResponse(code=500, message="Something went wrong in the server"), @ApiResponse(code=501, message="The requested operation is not supported by the target store"), @ApiResponse(code=503, message="The job service is not available")})
    public Response executeJob(Job var1) throws OperationException;

    @GET
    @ApiOperation(value="Get the details of all jobs", notes="While any Jobs are running, you can check the status of them all using this endpoint.", response=JobDetail.class, responseContainer="List", produces="application/json", responseHeaders={@ResponseHeader(name="job-id", description="The job execution ID."), @ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server"), @ApiResponse(code=503, message="The job service is not available")})
    public Response details() throws OperationException;

    @GET
    @Path(value="{id}")
    @ApiOperation(value="Get the details of a job", notes="This endpoint is useful for checking the details of a singular Job, given its Job ID. This shows information such as the current status, the user who executed the Job, startTime etc.", response=JobDetail.class, produces="application/json", responseHeaders={@ResponseHeader(name="job-id", description="The job execution ID."), @ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Job was not found"), @ApiResponse(code=500, message="Something went wrong in the server"), @ApiResponse(code=503, message="The job service is not available")})
    public Response details(@ApiParam(value="A job id, for which the details should be returned") @PathParam(value="id") String var1) throws OperationException;

    @GET
    @Path(value="{id}/results")
    @ApiOperation(value="Get the results of a job", notes="Once a Job has FINISHED, this endpoint will extract the results, and display them as one would expect from running an Operation/OpChain.", response=Object.class, responseContainer="List", produces="application/json", responseHeaders={@ResponseHeader(name="job-id", description="The job execution ID."), @ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server"), @ApiResponse(code=503, message="The job service is not available")})
    public Response results(@ApiParam(value="A job id, for which the results should be returned") @PathParam(value="id") String var1) throws OperationException;
}

