/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChain;

@Path(value="/graph/operations")
@Api(value="operations")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface IOperationServiceV2 {
    @GET
    @ApiOperation(value="Gets all operations supported by the store", notes="This endpoint returns a list of the fully qualified classpaths, for all operations supported by the store.", produces="application/json", response=String.class, responseContainer="list", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getOperations();

    @GET
    @Path(value="/details")
    @ApiOperation(value="Returns a List containing OperationDetails for all supported operations on the graph", produces="application/json", response=Object.class, responseContainer="list", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getOperationDetails();

    @POST
    @Path(value="/execute")
    @Produces(value={"application/json", "text/plain"})
    @ApiOperation(value="Performs the given operation on the graph", notes="Attempts to execute the provided operation on the graph, and returns the result below. Simple examples for each operation can be added using the drop-down below.", produces="application/json,text/plain", response=Object.class, responseHeaders={@ResponseHeader(name="job-id", description="The job execution ID."), @ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Object.class), @ApiResponse(code=400, message="Error while processing request body"), @ApiResponse(code=403, message="The current user cannot perform the requested operation"), @ApiResponse(code=500, message="Something went wrong in the server"), @ApiResponse(code=501, message="The requested operation is not supported by the target store")})
    public Response execute(@ApiParam(value="The operation to be performed on the graph") Operation var1);

    @POST
    @Path(value="/execute/chunked")
    @Produces(value={"application/json", "text/plain"})
    @ApiOperation(value="Performs the given operation on the graph, returning a chunked output", notes="<b>WARNING</b> - This does not work in Swagger.", response=Object.class, produces="application/json,text/plain")
    @ApiResponses(value={@ApiResponse(code=202, message="OK", response=Object.class), @ApiResponse(code=400, message="Error while processing request body"), @ApiResponse(code=403, message="The current user cannot perform the requested operation"), @ApiResponse(code=500, message="Something went wrong in the server"), @ApiResponse(code=501, message="The requested operation is not supported by the target store")})
    public Response executeChunked(@ApiParam(value="The operation to be performed, returning a chunked output") Operation var1);

    @SuppressFBWarnings
    public Response executeChunkedChain(@ApiParam(value="The operation chain to be performed, returning a chunked output") OperationChain var1);

    @GET
    @Path(value="/{className}")
    @ApiOperation(value="Gets details about the specified operation class", notes="This endpoint exposes the fields (and whether or not they are required); a list of all possible Operations that could follow it; and a small example in JSON, which includes the queried Operation class.", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="The current user cannot perform the requested operation"), @ApiResponse(code=404, message="Operation not found"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response operationDetails(@ApiParam(value="The fully qualified class name, for which details should be returned") @PathParam(value="className") String var1) throws InstantiationException, IllegalAccessException;

    @GET
    @Path(value="/{className}/example")
    @ApiOperation(value="Gets example JSON for the specified operation class", notes="Returns a fully justified and formatted JSON example of the given Operation, containing a few Operations for demonstration and usage purposes.", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="The current user cannot perform the requested operation"), @ApiResponse(code=404, message="Operation not found"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response operationExample(@ApiParam(value="The fully qualified class name, for which a formatted JSON example should be returned") @PathParam(value="className") String var1) throws InstantiationException, IllegalAccessException;

    @GET
    @Path(value="/{className}/next")
    @ApiOperation(value="Gets all the compatible operations which could follow the provided operation", notes="Returns a complete list of all possible compatible operations, that could follow the queried Operation in an OperationChain.", produces="application/json", response=String.class, responseContainer="list", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Operation not found"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response nextOperations(@ApiParam(value="The fully qualified class name, for which all possible compatible follow-up operations should be returned") @PathParam(value="className") String var1);
}

